' BrightScript code version 1.0.0.8
' https://github.com/rrirower

'''''''''
' Main: Main entry point of the channel.
' 
' @param {object} args - Associative array that contains content ID and media type.
'''''''''
sub Main(args as Object)
    ' Next lines DEBUG ONLY!
    'DebugClearRegistry()
    'DebugListRegistry()
    ShowChannelRSGScreen(args)
end sub

sub ShowChannelRSGScreen(args as Object)
    ' The RoSCScreen object is a SceneGraph canvas that displays the contents of a Scene node instance.
    screen = CreateObject("roSGScreen")
    ' message port is the place where events are sent.
    m.eventmessages = CreateObject("roMessagePort")
    ' sets the message port which will be used for events from the screen.
    screen.SetMessagePort(m.eventmessages)
    ' every screen object must have a Scene node, or a node that derives from the Scene node.
    scene = screen.CreateScene("MainScene")
    screen.Show() ' Init method in MainScene.brs is invoked.    
    ' Enable Roku registry display for VSCode.
    if true = CreateObject("roAppInfo").IsDev() then m.vscode_rdb_odc_node = createObject("roSGNode", "RTA_OnDeviceComponent") ' RDB OnDeviceComponent
    ' Required by Roku certification.
    scene.signalBeacon("AppLaunchComplete")
    ' Deep Linking: Save the launch arguments and set a flag.
    m.global = screen.getGlobalNode()
    m.global.id = "GlobalNode"
    m.global.addFields(args)
    m.global.addFields({
        "isDeepLink": false
    })
    ' Deep Linking: Create roInput object that receives events from ECP.
    inputObject = CreateObject("roInput")
    ' Deep Linking: Set the message port of the roInput object.
    inputObject.SetMessagePort(m.eventmessages)
    ' CHANNEL TITLE.
    channelTitle = m.global.TITLE
    m.global.addFields({
        "ChannelTitle": channelTitle
    })
    ' Do we require Subscriptions?
    if m.global.REQUIRE_SUBSCRIPTION
        webApiKey = m.global.WEB_API_KEY
        m.global.addFields({
            "WebApiKey": webApiKey
        })
    end if
    ' Check for Deep Linking Launch event.
    if args.DoesExist("mediaType") AND args.DoesExist("contentId")
        ' Save the passed arguments so that we can start Deep Linking.
        SaveDeepLinkingArgs(scene, args)
    end if
    ' Main event loop.
    while (true)
        ' waiting for events from the screen
        msg = wait(0, m.eventmessages)
        msgType = type(msg)
        ' Next line for debugging only.
        'DebugPrint(msgType)
        if msgType = "roSGScreenEvent"
            if msg.IsScreenClosed() then
                return
            end if
        end if
    end while
end sub

'''''''''
' SaveDeepLinkingArgs: Saves the Deep Linking arguments for later use.
' 
' @param {string} I: _scene - the Main scene object.
' @param {string} I: _arguments - the passed arguements from Roku.
'''''''''
function SaveDeepLinkingArgs(_scene as object, _arguments as object) as void
    ' Define an array for Deep linking arguments.
    deepLinkArgsArray = {}
    ' Massage the 'contentId' field if started from a Launch event.
    if _arguments.DoesExist("contentId")
        ' Save the 'id' as we expect it.
        _arguments["id"] = _arguments["contentId"]
        ' Remove the 'contentId' from the Launch event.
        _arguments.Delete("contentId")
    end if
    ' Parsed the passed arguments so we can store them in the global node.
    for each arg in _arguments.Items()
        keyString = CreateObject("roString")
        keyString.SetString("dl_%s")
        dlKey = keyString.Format(arg.key)
        deepLinkArgsArray[dlKey] = arg.value
    end for
    m.global.addFields(deepLinkArgsArray)
    m.global.isDeepLink = true
    ' Setting inputArgs triggers the OnInputDeepLinking event.
    _scene.inputArgs = deepLinkArgsArray
end function'//# sourceMappingURL=./main.bs.map