' Theme class
' (c) Copyright 2024, Michael Harnad
function __Theme_builder()
    instance = {}
    '''''''''
    ' new: Class constructor.
    ' 
    ' @param {string} I: screenName - name of the screen.
    '''''''''
    instance.new = sub(screenName as string)
        m._screenName = invalid
        m._themeJson = invalid
        m._screen = invalid
        m._screenName = screenName
        m._themeJson = ParseJson(ReadAsciiFile("pkg:/source/theme.json"))
        for each screen in m._themeJson.screens
            if screen.name = m._screenName
                m._screen = screen
                exit for
            end if
        end for
    end sub
    '''''''''
    ' GetFonts: Retrieves an array of font(s) from the theme file.
    ' 
    ' @param {string} I: _screenField - the name of the screen field to apply the font.
    ' @return {object} - returns array of the associated font(s) if found, else, null.
    '''''''''
    instance.GetFonts = function(_screenField as string) as object
        fonts = []
        if m._screen[_screenField] <> invalid
            for each attributeArray in m._screen[_screenField]
                fontsArray = attributeArray.Lookup("fonts")
                if fontsArray <> invalid
                    for each font in fontsArray
                        fonts.Push(font)
                    end for
                    return fonts
                end if
            end for
        end if
        return ""
    end function
    '''''''''
    ' SetFont: Sets the font of the passed object.
    ' 
    ' @param {object} I: _screenField - the _screenField MUST support drawingStyles.
    ' @param {string} I: _fontNames - array of font names to use.
    '''''''''
    instance.SetFont = function(_screenField as object) as void
        objectStyle = {}
        fonts = m.GetFonts(_screenField.id)
        ' Make sure the object and the font name are valid.
        if _screenField <> invalid
            for each font in fonts
                objectStyle.Append(font)
            end for
            _screenField.drawingStyles = objectStyle
        end if
    end function
    '''''''''
    ' ConstructBracket: Constructs the Font brackets for the text.
    ' 
    ' @param {string} I: _fontName - the font name.
    ' @param {boolean} I: [_close=false] - true for closing bracket, else, false.
    ' @return {string} - returns the font bracket.
    '''''''''
    instance.ConstructBracket = function(_fontName as string, _close = false as boolean) as string
        result = ""
        if _close = false
            result = "<" + _fontName + ">"
        else
            result = "</" + _fontName + ">"
        end if
        return result
    end function
    '''''''''
    ' FormatText: Formats the past screenField's text using its associated font.
    ' 
    ' @param {object} I: _screenField - the screen field.
    ' @param {string} I: _text - the text to format.
    ' @param {integer} I: [_fontIndex=0] - the font index to use if not the default.
    ' @return {string} - returns the formatted text.
    '''''''''
    instance.FormatText = function(_screenField as object, _text as string, _fontIndex = 0 as integer) as string
        stringObj = CreateObject("roString")
        if _screenField <> invalid
            ' Get the fonts for this screen field.
            fonts = m.GetFonts(_screenField.id)
            fontToUse = fonts.GetEntry(_fontIndex)
            ' Get the font's attributes.
            fontAttribs = fontToUse.Keys()
            ' Format the field text.
            br = m.ConstructBracket(fontAttribs[0])
            stringObj.AppendString(br, Len(br))
            stringObj.AppendString(_text, Len(_text))
            br = m.ConstructBracket(fontAttribs[0], true)
            stringObj.AppendString(br, Len(br))
        end if
        return stringObj
    end function
    '''''''''
    ' SetButtonFont: Sets the button font for a ButtonGroup.
    ' 
    ' @param {object} I: _screenField - the refrenece to the ButtonGroup.
    ' @param {object} O: _textColors - associative array that receives the defined colors.
    ' @param {integer} I: [_fontIndex=0] - the font index to use if not the default.
    ' @return {object} - returns the Font object.
    '''''''''
    instance.SetButtonFont = function(_screenField as object, _textColors as object, _fontIndex = 0 as integer) as object
        buttonFont = invalid
        if _screenField <> invalid
            buttonFont = CreateObject("roSGNode", "Font")
            fonts = m.GetFonts(_screenField.id)
            fontToUse = fonts.GetEntry(_fontIndex)
            ' Get the font's attributes.
            fontItems = fontToUse.Items()[0]
            fontAttribs = fontItems.value
            buttonFont.uri = fontAttribs.FontUri
            buttonFont.size = fontAttribs.fontSize
            _textColors["textColor"] = fontAttribs.textColor
            _textColors["focusedTextColor"] = fontAttribs.focusedTextColor
        end if
        return buttonFont
    end function
    '''''''''
    ' GetObjectText: Gets the text of a screen object.
    ' 
    ' @param {string} I: _screenField - the screen field name.
    ' @param {string} I: _objectName - the object within the _screenField.
    ' @return {string} - returns the object text.
    '''''''''
    instance.GetObjectText = function(_screenField as string, _objectName as string) as string
        if _screenField <> invalid
            ' Get the field object.
            fieldObject = m._screen[_screenField]
            for each entry in fieldObject
                if entry["strings"] <> invalid
                    if entry["strings"][_objectName] <> invalid
                        return entry["strings"][_objectName]
                    end if
                end if
            end for
        end if
        return "Not Found"
    end function
    '''''''''
    ' GetObjectImage: Gets the image of a screen object.
    ' 
    ' @param {object} I: _screenField - the screen field.
    ' @param {string} I: _objectName - the object within the _screenField.
    ' @return {string} - returns the image file path.
    '''''''''
    instance.GetObjectImage = function(_screenField as object, _objectName as string) as string
        if _screenField <> invalid
            ' Get the field object.
            fieldObject = m._screen[_screenField]
            for each entry in fieldObject
                if entry["images"] <> invalid
                    if entry["images"][_objectName] <> invalid
                        return entry["images"][_objectName]
                    end if
                end if
            end for
        end if
        return ""
    end function
    '''''''''
    ' GetObjectColor: Gets the color of a screen object.
    ' 
    ' @param {object} I: _screenField - the screen field.
    ' @param {integer} I: [_fontIndex=0] - the font index to use if not the default.
    ' @return {string} - returns the color code if ok, else, black (#000000)
    '''''''''
    instance.GetObjectColor = function(_screenField as object, _fontIndex = 0 as integer) as string
        color = "#000000"
        if _screenField <> invalid
            ' Get the fonts for this screen field.
            fonts = m.GetFonts(_screenField.id)
            fontToUse = fonts.GetEntry(_fontIndex)
            ' Get the font's attributes.
            fontItems = fontToUse.Items()[0]
            fontAttribs = fontItems.value
            color = fontAttribs.color
        end if
        return color
    end function
    return instance
end function
function Theme(screenName as string)
    instance = __Theme_builder()
    instance.new(screenName)
    return instance
end function'//# sourceMappingURL=./Theme.bs.map