



sub Init()
    ' Create url transefer object.
    m.xfer = CreateObject("roURLTransfer")
    m.xfer.SetCertificatesFile("common:/certs/ca-bundle.crt")
    ' set the name of the function in the Task node component to be executed when the state field changes to RUN.
    m.top.functionName = "CallApiFunction"
end sub

'''''''''
' CallApiFunction: Calls a Rest API function.
' 
'''''''''
sub CallApiFunction()
    RestUrl = "https://apipub.roku.com/listen/transaction-service.svc/" + m.top.endpoint
    if m.top.endpoint = "validate-transaction"
        RestUrl += "/" + m.global.webApiKey + "/" + m.top.transid
        m.xfer.SetURL(RestUrl)
        m.xfer.AddHeader("accept", "application/json")
        rsp = m.xfer.GetToString()
        ' Did we get a good response?
        if rsp <> ""
            json = ParseJson(rsp)
            if json.isEntitled = true
                m.top.isEntitled = true
            end if
        else
            m.top.isEntitled = false
        end if
    else if m.top.endpoint = "cancel-subscription"
        jsonBody = {
            "partnerAPIKey": m.global.webApiKey
            "transactionId": m.top.transid
        }
        m.xfer.SetURL(RestUrl)
        m.xfer.SetRequest("POST")
        m.xfer.AddHeader("Content-Type", "application/json")
        rsp = m.xfer.PostFromString(FormatJson(jsonBody))
    end if
end sub'//# sourceMappingURL=./WebServiceApiTask.bs.map