'import "pkg:/components/ServerResources/ServerResources.bs"

sub Init()
    ' Read the server resources.
    m.serverResources = ServerResources(0)
    ' Create url transefer object.
    m.xfer = CreateObject("roURLTransfer")
    m.xfer.SetCertificatesFile("common:/certs/ca-bundle.crt")
    ' set the name of the function in the Task node component to be executed when the state field changes to RUN.
    m.top.functionName = "CallSubscriptionAPI"
end sub

'''''''''
' CallSubscriptionAPI: Execute the Subscription server API call.
' 
'''''''''
sub CallSubscriptionAPI()
    ' Set the URL to the Subscription sever with the associated endpoint.
    SubscriptionServerEndpointUrl = m.serverResources.GetSubscriptionServerURL(m.top.endpoint)
    ' Build the Rest URL.
    RestUrl = BuildRestUrl(m.top.endpoint, SubscriptionServerEndpointUrl)
    m.xfer.SetURL(RestUrl)
    ' Return a JSON response.
    m.xfer.AddHeader("accept", "application/json")
    rsp = m.xfer.GetToString()
    json = ParseJson(rsp)
    m.top.response = json
end sub

'''''''''
' BuildRestUrl: Builds the complete Rest URL.
' 
' @param {string} I: _endpoint - the endpoint.
' @param {string} I: _endpointUrl - the endpoint url.
' @return {string} - returns the complete Rest URL.
'''''''''
function BuildRestUrl(_endpoint as string, _endpointUrl as string) as string
    RestUrl = ""
    if _endpoint = "validate-token"
        RestUrl = _endpointUrl + "?accessToken=" + m.top.accessToken
    else if _endpoint = "check-linked-subscription"
        RestUrl = _endpointUrl + "?email=" + m.top.email
    else if _endpoint = "validate-credentials"
        RestUrl = _endpointUrl + "?email=" + m.top.email + "&password=" + m.top.password
    else if _endpoint = "get-access-token"
        RestUrl = _endpointUrl
    else if _endpoint = "validate-new-order"
        RestUrl = _endpointUrl + "?email=" + m.top.email + "&firstname=" + m.top.firstname + "&lastname=" + m.top.lastname
    else if _endpoint = "check-entitlement"
        RestUrl = _endpointUrl + "?transid=" + m.top.transid
    end if
    return RestUrl
end function'//# sourceMappingURL=./SubscriptionServerApiTask.bs.map