' (c) Copyright 2024, Michael Harnad
'import "pkg:/source/utils.bs"


'''''''''
' Init: Inititializes the Input task.
' 
'''''''''
Sub Init()
    m.messagePort = CreateObject("roMessagePort")
    m.top.observeField("transportResponse", m.messagePort)
    'm.xfer = createObject("roUrlTransfer")
    m.transportIdList = {}
    m.top.functionName = "ListenForInput"
End Sub

'''''''''
' ListenForInput: Listens for input events.
' 
'''''''''
function ListenForInput() as void
    InputObject = CreateObject("roInput")
    InputObject.setmessageport(m.messagePort)
    InputObject.enableTransportEvents()
    while true
        msgEvent = m.messagePort.waitmessage(500)
        msgType = type(msgEvent)
        ' roInputEvent.
        if msgType = "roInputEvent"
            eventData = msgEvent.getInfo()
            ' Roku Voice event.
            if eventData.type = "transport"
                transport = {
                    id: eventData.id
                    command: eventData.command
                    duration: eventData.duration
                    direction: eventData.direction
                    type: eventData.type
                }
                m.transportIdList[eventData.id] = {
                    transport: transport
                }
                m.top.inputData = transport
                ' Roku Deeplink event.
            else
                if eventData.DoesExist("mediaType") AND eventData.DoesExist("contentID")
                    deeplink = {
                        id: eventData.contentID
                        mediaType: eventData.mediaType
                        type: "deeplink"
                    }
                    if eventData.DoesExist("Episode")
                        deeplink.episode = eventData.episode
                    end if
                    if eventData.DoesExist("Season")
                        deeplink.season = eventData.season
                    end if
                    m.top.inputData = deeplink
                end if
            end if
            ' roSGNodeEvent.
        else if msgType = "roSGNodeEvent"
            if msgEvent.getField() = "transportResponse"
                response = msgEvent.getData()
                id = response.id
                job = m.transportIdList[id]
                if job <> invalid
                    eventStatus = response.status
                    ' Send the response (may need to be after command executed)
                    InputObject.EventResponse({
                        id: response.id
                        status: eventStatus.status
                    })
                    m.transportIdList.delete(id)
                else
                    DebugPrint("id= " + id + " not found")
                end if
            end if
        end if
    end while
end function'//# sourceMappingURL=./InputTask.bs.map