' (c) Copyright 2024, Michael Harnad
'import "pkg:/components/UILogic/VotingBookmarkLogic.bs"


sub Init()
    ' Create url transefer object.
    m.xfer = CreateObject("roURLTransfer")
    m.xfer.SetCertificatesFile("common:/certs/ca-bundle.crt")
    ' set the name of the function in the Task node component to be executed when the state field changes to RUN.
    m.top.functionName = "VoteForContent"
    m.top.endpoint = "https://ibe0a4k9v8.execute-api.us-east-1.amazonaws.com/Test/content-voting/"
end sub

'''''''''
' VoteForContent: Calls a Rest API function.
' 
'''''''''
sub VoteForContent()
    RestUrl = "https://ibe0a4k9v8.execute-api.us-east-1.amazonaws.com/Test/content-voting/"
    RestUrl += "?contentid=" + m.top.contentid + "&vote=" + m.top.vote
    m.xfer.SetURL(RestUrl)
    m.xfer.AddHeader("accept", "application/json")
    rsp = m.xfer.GetToString()
    ' Did we get a good response?
    if rsp <> ""
        UpdateVotingDB(m.top.contentid, m.top.vote)
        json = ParseJson(rsp)
        m.top.status = json["body"]
    end if
end sub

'''''''''
' UpdateVotingDB: Update the voting database to save the vote.
' 
' @param {string} I: _contentID - the content ID.
' @param {string} I: _vote - the vote.
' @return {dynamic}
'''''''''
function UpdateVotingDB(_contentID as string, _vote as string) as void
    VotingDB = VotingBookmarkClass(_contentID, _vote)
    VotingDB.SaveTheVote()
end function'//# sourceMappingURL=./ContentVotingTask.bs.map