' (c) Copyright 2024, Michael Harnad
'import "pkg:/components/UILogic/BookmarkLogic.bs"
'import "pkg:/source/utils.bs"

' Per Roku Certification 4.10, 30 days for minimum bookmarks.


sub Init()
    DebugPrint("Starting Cleanup tasks.")
    ' Set the function to run.
    m.top.functionName = "RunCleanup"
    ' Create a DateTime object.
    dateTimeObject = CreateObject("roDateTime")
    m.todayEpoch = dateTimeObject.AsSeconds()
end sub

'''''''''
' RunCleanup: Runs any cleanup processes.
' 
'''''''''
function RunCleanup() as void
    ' Remove expired video bookmarks.
    RemoveExpiredVideoBookmarks()
    DebugPrint("Cleanup tasks ended.")
    m.top.taskend = true
    m.top.control = "stop"
end function

'''''''''
' RemoveExpiredVideoBookmarks: Removes any expired video bookmarks.
' 
'''''''''
function RemoveExpiredVideoBookmarks() as void
    DebugPrint("Cleanup task: RemoveExpiredVideoBookmarks")
    videoBookmarkClass = Bookmark()
    videoBookmarkList = videoBookmarkClass.GetKeyList()
    if videoBookmarkList.Count() > 0
        for each contentId in videoBookmarkList
            bookmarkCreationDate = videoBookmarkClass.GetBookmarkProperty(contentId, "creationDate").toInt()
            bookmarkDuration = m.todayEpoch - bookmarkCreationDate
            if bookmarkDuration >= (30 * 86400)
                DebugPrint("Removing expired bookmark " + contentId)
                videoBookmarkClass.DeleteBookmark(contentId)
            end if
        end for
    end if
end function'//# sourceMappingURL=./CleanupTask.bs.map