' VotingBookmark class
' (c) Copyright 2024, Michael Harnad
'import "pkg:/components/UILogic/BookmarkLogic.bs"

function __VotingBookmarkClass_builder()
    instance = __Bookmark_builder()
    '''''''''
    ' new: Class constructor.
    ' 
    ' @param {string} I: _contentID - the content ID as key.
    ' @param {string} I: _vote - the content vote.
    '''''''''
    instance.super0_new = instance.new
    instance.new = sub(_contentID as string, _vote as string)
        ' Call the base class constructor.
        m._contentId = invalid
        m._vote = invalid
        m.super0_new("ContentVotingDB")
        ' Set some default values.
        m._contentId = _contentID
        m._vote = _vote
    end sub
    ' The content ID.
    ' The content vote.
    instance.SaveTheVote = function()
        m.super0_WriteBookmark(m._contentId, m._vote)
    end function
    '''''''''
    ' ReadBookmark: Read a vote from the registry.
    ' 
    ' @param {string} I: _key - the content ID as key.
    ' @return {string} - returns the content vote if found, else, "".
    '''''''''
    instance.super0_ReadBookmark = instance.ReadBookmark
    instance.ReadBookmark = function(_key as string) as string
        return m.super0_ReadBookmark(_key)
    end function
    '''''''''
    ' WriteBookmark: Save the content vote to the registry.
    ' 
    '''''''''
    instance.super0_WriteBookmark = instance.WriteBookmark
    instance.WriteBookmark = function()
        m.super0_WriteBookmark(m._contentId, m._vote)
    end function
    return instance
end function
function VotingBookmarkClass(_contentID as string, _vote as string)
    instance = __VotingBookmarkClass_builder()
    instance.new(_contentID, _vote)
    return instance
end function'//# sourceMappingURL=./VotingBookmarkLogic.bs.map