'import "pkg:/source/main.bs"
'import "pkg:/source/Theme.bs"
'import "pkg:/components/UILogic/ScreenStackLogic.bs"
'import "pkg:/components/UILogic/Watched.bs"
'import "pkg:/components/UILogic/VideoPlayerWithAds.bs"
' Number of seconds before the end of the Episode to start the countdown.


'''''''''
' ShowVideoScreen: Show the Video screen and play some content.
' 
' @param {object} I: feedContent - the content object to play.
' @param {integer} I: _selectedItem - selected item index.
' @param {boolean} I: [isSeries=false] - Series flag.
'''''''''
sub ShowVideoScreen(feedContent as object, _selectedItem as integer, isSeries = false as boolean)
    ' Set the MainScene context.
    mainScene = (function(__bsCondition, m)
            if __bsCondition then
                return m.top
            else
                return m.top.GetParent()
            end if
        end function)(m.top.SubType() = "MainScene", m)
    ' Save Series flag.
    m.isSeries = isSeries
    ' Save playAll flag.
    m.playAll = feedContent.PlayAll
    ' Define the default video start position.
    position = [
        0.0
    ]
    ' Define a bookmark object.
    playbackBookmark = Bookmark()
    ' Save the current playback content to the global node.
    m.global.addFields({
        "CurrentPlaybackContent": feedContent
    })
    ' Check for restart request.
    if feedContent.restart = true
        ResetBookmark(feedContent)
        ' Remove the restart indicator.
        feedContent.removeField("restart")
    end if
    ' Set the start position for the content.
    SetPlaybackPosition(feedContent, position)
    ' Define some playback settings.
    playbackContent = invalid
    contentIsPlaylist = false
    playbackId = invalid
    playbackMediaType = invalid
    ' Series.
    if feedContent.mediaType = "series"
        playlistNode = CreatePlaylistFromSeries(feedContent)
        firstEpisode = playlistNode.getChild(0)
        firstEpisode.playStart = feedContent.PlayStart
        playbackId = firstEpisode.id
        playbackContent = playlistNode
        contentIsPlaylist = true
        m.global.CurrentPlaybackContent = firstEpisode
        playbackMediaType = "episode"
        ' Episodes.
    else if feedContent.mediaType = "episode"
        startingEpisodeIndex = feedContent.episodeIndex
        playlistNode = CreatePlaylistFromEpisodes(feedContent, startingEpisodeIndex)
        firstEpisode = playlistNode.getChild(0)
        firstEpisode.playStart = feedContent.PlayStart
        playbackId = firstEpisode.id
        playbackContent = playlistNode
        contentIsPlaylist = true
        m.global.CurrentPlaybackContent = firstEpisode
        playbackMediaType = "episode"
        ' Movies, ShortFormVideos, TVSpecials, etc.
    else
        playbackContent = feedContent
        if feedContent.length <> invalid AND feedContent.length > 0
            playbackContent.length = feedContent.length
        else
            playbackContent.length = feedContent.content.duration
        end if
        playbackId = feedContent.id
        contentIsPlaylist = false
        m.global.CurrentPlaybackContent = playbackContent
        playbackMediaType = feedContent.mediaType
    end if
    ' If user channel uses RAF, show content with ads.  
    ' Otherwise, just start the video content.
    if m.global.USE_RAF
        PlayContentWithAds(playbackContent, playbackMediaType)
    else
        ' Save a reference to the Theme object.
        m.theme = Theme("MainScene")
        m.videoPlayer = mainScene.FindNode("Video")
        m.videoPlayer.visible = true
        ' Set some Video player settings.
        m.videoPlayer.content = playbackContent
        if m.videoPlayer.hasField("playbackId")
            m.videoPlayer.setFields({
                "playbackId": playbackId
            })
        else
            m.videoPlayer.addFields({
                "playbackId": playbackId
            })
        end if
        m.videoPlayer.contentIsPlaylist = contentIsPlaylist
        m.videoPlayer.content.addFields({
            "mediaType": playbackMediaType
        })
        ' Set the playback bookmark.
        playbackBookmark.UpdatePlaybackBookmark(m.videoPlayer)
        ' Show the video screen.
        ShowScreen(m.videoPlayer)
        ' Seek to the start position.
        m.videoPlayer.seek = feedContent.PlayStart
        m.videoPlayer.control = "play" ' start playback
        m.videoPlayer.ObserveField("state", "OnVideoPlayerStateChange")
        m.videoPlayer.ObserveField("visible", "OnVideoVisibleChange")
        m.videoPlayer.ObserveField("contentIndex", "OnPlaylistIndexChange")
        ' If the playback is an Episode, set the framework for a countdown timer.
        if playbackMediaType = "episode"
            ' Observe the video position.
            m.videoPlayer.ObserveField("position", "OnVideoPositionChanged")
            ' Set the text for the countdown timer.
            m.label = mainScene.FindNode("nextUpLabel")
            m.theme.SetFont(m.label)
            labelText = m.theme.GetObjectText("nextUpLabel", "nextUpLabel")
            m.label.text = m.theme.FormatText(m.label, labelText)
            m.nextEpisodeLabel = mainScene.FindNode("nextEpisodeTitleLabel")
            m.theme.SetFont(m.nextEpisodeLabel)
            m.nextEpisodeThumbnail = mainScene.FindNode("nextEpisodeThumbnail")
            m.returnImage = mainScene.FindNode("returnImage")
            m.returnImage.uri = "pkg:/images/left arrow.png"
            m.returnLabel = mainScene.FindNode("returnLabel")
            m.theme.SetFont(m.returnLabel)
            returnText = m.theme.GetObjectText("returnLabel", "returnLabel")
            m.returnLabel.text = m.theme.FormatText(m.returnLabel, returnText)
            ' Get the current Episode that is set to play.
            currentEpisode = m.global.CurrentPlaybackContent
            ' Get the next Episode.
            m.nextEpisode = FindNextEpisodeInPlaylist(currentEpisode, m.videoPlayer.content)
            if m.nextEpisode <> invalid
                ' Get the title of the next Episode.
                m.nextEpisodeLabel.text = m.theme.FormatText(m.nextEpisodeLabel, m.nextEpisode.title)
                ' Get the thumbnail for the next Episode.
                m.nextEpisodeThumbnail.uri = m.nextEpisode.thumbnail
            end if
        end if
    end if
end sub

'''''''''
' OnVideoPositionChanged: Event Handler - Handles video position change event.
' 
'''''''''
sub OnVideoPositionChanged()
    ' Get the time left for the video.
    timeleft = cint(m.videoPlayer.duration - m.videoPlayer.position)
    if timeleft <= 10 AND timeleft >= 1
        if m.nextEpisode <> invalid
            labelText = m.theme.GetObjectText("nextUpLabel", "nextUpLabel")
            label = labelText + timeleft.toStr()
            m.label.text = label
            m.label.visible = true
            m.nextEpisodeLabel.visible = true
            m.nextEpisodeThumbnail.visible = true
            m.returnImage.visible = true
            m.returnLabel.visible = true
        end if
    else if timeleft = 0
        m.label.visible = false
        m.nextEpisodeLabel.visible = false
        m.nextEpisodeThumbnail.visible = false
        m.returnImage.visible = false
        m.returnLabel.visible = false
    end if
end sub

'''''''''
' OnVideoPlayerStateChange: Event handler - called when the state of the video player changes.
' 
'''''''''
sub OnVideoPlayerStateChange()
    ' Get the player state.
    state = m.videoPlayer.state
    ' Video - Paused.
    if state = "paused"
        ' Update the content bookmark in the registry.
        m.contentBookmark.UpdatePlaybackBookmark(m.videoPlayer)
    end if
    ' Video - Stopped.
    if state = "stopped"
        ' Update the content bookmark in the registry.
        m.contentBookmark.UpdatePlaybackBookmark(m.videoPlayer)
    end if
    ' Video - Finished.
    if state = "finished"
        ' Stop watching for "state" changes.
        m.videoPlayer.UnobserveField("state")
        bookmarkToRemove = invalid
        ' Create a 'Watched' bookmark.
        if m.videoPlayer.contentIsPlaylist = false
            MarkVideoAsWatched(m.videoPlayer.content.id)
            bookmarkToRemove = m.videoPlayer.content
        else
            bookmarkToRemove = m.videoPlayer.content.getChild(0)
            MarkVideoAsWatched(m.videoPlayer.playbackId)
        end if
        ' Remove the 'Video' bookmark.
        ResetBookmark(bookmarkToRemove)
        CloseScreen(m.videoPlayer)
    end if
    ' Video - Playback error.
    if state = "error"
        description = []
        description.Push(m.videoPlayer.errorMsg)
        m.errorDialog = createObject("roSGNode", "StandardMessageDialog")
        m.errorDialog.title = m.videoPlayer.state + ": " + m.videoPlayer.errorStr
        m.errorDialog.message = description
        m.errorDialog.buttons = [
            "Ok"
        ]
        ' observe the dialog's buttonSelected field to handle button selections
        m.errorDialog.observeFieldScoped("buttonSelected", "onOkButtonSelected")
        ' display the dialog
        scene = m.top.getScene()
        scene.dialog = m.errorDialog
    end if
end sub

'''''''''
' onOkButtonSelected: Handles Ok button click on the Description Dialog.
' 
'''''''''
sub onOkButtonSelected()
    m.errorDialog.close = true
    CloseScreen(m.videoPlayer)
end sub

'''''''''
' OnVideoVisibleChange: Event handler - called when the visibility of the Video node changes.
' 
'''''''''
sub OnVideoVisibleChange()
    if m.videoPlayer.visible = false
        ' the index of the video in the video playlist that is currently playing.
        m.videoPlayer.control = "stop" ' stop playback
        'clear video player content, for proper start of next video player
        m.videoPlayer.content = invalid
        ' Clear the Playall flag.
        m.playAll = false
        m.isSeries = false
        screen = GetCurrentScreen()
        screen.SetFocus(true) ' return focus to details screen
        ' In case of series we shouldn't change focus.
        if screen.isSeries = false AND screen.subType() = "GridScreen"
            screen.jumpToRowItem = screen.lastIndex
        end if
    end if
end sub

'''''''''
' OnPlaylistIndexChange: Handles change in the playlist index.  This occurs when the next item starts playback.
' 
'''''''''
sub OnPlaylistIndexChange()
    ' Get the index within the playlist of the currently playing video.
    contentIndex = m.videoPlayer.contentIndex
    ' Check to see if the user is in the process of stopping video playback.
    if m.videoPlayer.state <> "stop" AND contentIndex <> 0
        ' Get the prior video that just finished playing.
        priorVideo = m.videoPlayer.content.getChild(contentIndex - 1)
        ' Mark it as 'Watched'.
        MarkVideoAsWatched(priorVideo.id)
        ' Remove its Video bookmark.
        ResetBookmark(priorVideo)
        ' Set a bookmark for the current video.
        currentVideo = m.videoPlayer.content.getChild(contentIndex)
        videoBookmark = Bookmark()
        videoBookmark.WriteNewEpisodeBookmark(currentVideo)
        ' Set the global CurrentPlaybackContent.
        m.global.CurrentPlaybackContent = currentVideo
        m.videoPlayer.playbackId = currentVideo.id
    end if
end sub

'''''''''
' SetPlaybackPosition: Set the Video playback position based on any bookmark.
' 
' @param {object} I: feedContent - the feed content object.
' @param {object} O: position - the playback position.
'''''''''
function SetPlaybackPosition(feedContent as object, position as object) as void
    ' Get the Bookmark object.
    m.contentBookmark = Bookmark()
    if m.contentBookmark.VideoCanBeResumed(feedContent.id, position) = true
        feedContent.PlayStart = position[0]
    end if
end function

'''''''''
' ResetBookmark: Resets the content bookmark by removing it.
' 
' @param {object} I: _feedContent - the feed content.
' @return {dynamic}
'''''''''
function ResetBookmark(_feedContent as object)
    ' Get the Bookmark object.
    m.contentBookmark = Bookmark()
    ' Reset the playback position.
    _feedContent.PlayStart = 0.0
    ' Remove the bookmark.
    m.contentBookmark.DeleteBookmark(_feedContent.id)
end function'//# sourceMappingURL=./VideoPlayer.bs.map