' (c) Copyright 2024, Michael Harnad
'import "pkg:/components/UILogic/ScreenStackLogic.bs"
'import "pkg:/components/UILogic/TagContentScreenLogic.bs"
'import "pkg:/source/utils.bs"

'''''''''
' ShowSearchScreen: Shows the Search Screen.
' 
'''''''''
sub ShowTagsScreen()
    ' Create the Tags screen.
    m.TagsScreen = CreateObject("roSGNode", "TagsScreen")
    ' Get a reference to the poster grid.
    m.tagGrid = m.TagsScreen.FindNode("tagPosterGrid")
    m.tagGrid.observeField("itemSelected", "OnTagSelected")
    ' Show the Tags screen.
    ShowScreen(m.TagsScreen)
end sub

'''''''''
' OnTagSelected: Event Handler - handles click on tag.
' 
' @param {object} I: _tag - the index of the selected tag.
'''''''''
sub OnTagSelected(_tag as object)
    selectedTagItems = []
    ' Get the index of the selected item.
    tagIndex = _tag.GetData()
    ' Get the associated tag.
    tagContent = m.tagGrid.content.getChild(tagIndex)
    ' Build a list of tag content.
    for each indexItem in m.global.ContentIndex
        if indexItem.tags <> invalid and indexItem.tags.Count() > 0
            for each tag in indexItem.tags
                if tag = tagContent.shortdescriptionline1
                    selectedTagItems.Push(indexItem)
                end if
            end for
        end if
    end for
    ' Show the tag content screen.
    ShowTagContentScreen(selectedTagItems)
end sub'//# sourceMappingURL=./TagScreenLogic.bs.map