' (c) Copyright 2024, Michael Harnad
'import "pkg:/components/UILogic/ScreenStackLogic.bs"

'''''''''
' ShowTagContentScreen: Show the Tag Content screen.
' 
' @param {object} I: _selectedTagContentArray - array of content items.
'''''''''
function ShowTagContentScreen(_selectedTagContentArray as object) as void
    ' Create the Tag content screen.
    m.TagContentScreen = CreateObject("roSGNode", "TagContentScreen")
    m.TagContentScreen.tagSelectedContent = _selectedTagContentArray
    ' Show the Tag Content screen.
    ShowScreen(m.TagContentScreen)
end function

'''''''''
' BuildArrayOfMediaTypes: Build an array of content based on the requested media type.
' 
' @param {string} I: _mediaType - the requested media type.
' @return {object} - returns an array of that type for the grid.
'''''''''
function BuildArrayOfMediaTypes(_mediaType as string) as object
    contentArray = []
    ' Collect all of the requested media types.
    for each indexItem in m.global.ContentIndex
        if indexItem.mediaType = _mediaType
            item = {}
            item["id"] = indexItem.id
            item["mediaType"] = indexItem.mediaType
            contentArray.Push(item)
        end if
    end for
    return contentArray
end function'//# sourceMappingURL=./TagContentScreenLogic.bs.map