'import "pkg:/components/UILogic/ScreenStackLogic.bs"

'sub ShowEpisodesScreen(content as Object, selectedItem as Integer)
sub ShowEpisodesScreen(_series as object)
    ' create instance of the EpisodesScreen
    m.episodesScreen = CreateObject("roSGNode", "EpisodesScreen")
    ' observe selectedItem field so we can know which episode is selected
    m.episodesScreen.ObserveField("selectedItem", "OnEpisodesScreenItemSelected")
    ' populate episodeScreen with content based on which series was chosen
    m.episodesScreen.content = _series
    ShowScreen(m.episodesScreen)
end sub

sub OnEpisodesScreenItemSelected(event as Object)
    episodesScreen = event.GetRoSGNode()
    ' extract the row and column indexes of the item the user selected
    selectedIndex = event.GetData()
    ' Add to the content payload by saving the selected Season index and the selected Epsiode index.
    episodesScreen.content.removeFields([
        "SelectedSeasonIndex"
        "SelectedEpisodeIndex"
    ])
    episodesScreen.content.addFields({
        "SelectedSeasonIndex": selectedIndex[0]
    })
    episodesScreen.content.addFields({
        "SelectedEpisodeIndex": selectedIndex[1]
    })
    ' Clear the PlayAll flag since the user has requeted to play a single Episode.
    episodesScreen.content.removeFields([
        "PlayAll"
    ])
    episodesScreen.content.addFields({
        "PlayAll": false
    })
    ' Get the selected Season.
    season = GetSeasonFromSeries(episodesScreen.content, selectedIndex[0])
    ' Handle the OK (Play) button.
    HandlePlayButton(season, selectedIndex[1])
end sub'//# sourceMappingURL=./SeasonsWithEpisodesScreenLogic.bs.map