

function InitScreenStack()
    m.screenStack = CreateObject("roSGNode", "ScreenStack")
end function

'''''''''
' IsChildScreen: Checks to see if the screen is a child of the MainScene.
' 
' @return {boolean} - returns true if the screen is a child, else, false.
'''''''''
function IsChildScreen() as boolean
    isChild = false
    for each screen in ([
        "SearchScreen"
        "MainMenuComponent"
        "TagContentScreen"
    ])
        if screen = m.top.SubType()
            isChild = true
            exit for
        end if
    end for
    return isChild
end function

sub ShowScreen(node as Object)
    ' Define a screen stack variable.
    appscreenStack = invalid
    if IsChildScreen()
        mainScene = m.top.GetScene()
        appscreenStack = mainScene.callfunc("GetScreenStack", invalid)
        appscreenStack.screenNode = node
        appscreenStack.action = "Show"
    else
        if node <> invalid and node.SubType() = "Video"
            mainScene = m.top.GetScene()
            m.screenStack = mainScene.callfunc("GetScreenStack", invalid)
        end if
        m.screenStack.screenNode = node
        m.screenStack.action = "Show"
    end if
end sub

sub CloseScreen(node = invalid as Object)
    ' Define a screen stack variable.
    appscreenStack = invalid
    if IsChildScreen()
        mainScene = m.top.GetScene()
        appscreenStack = mainScene.callfunc("GetScreenStack", invalid)
        appscreenStack.screenNode = node
        appscreenStack.action = "Close"
    else
        m.screenStack.screenNode = node
        m.screenStack.action = "Close"
    end if
end sub

sub ClearScreenStack()
    ' Define a screen stack variable.
    appscreenStack = invalid
    if IsChildScreen()
        mainScene = m.top.GetScene()
        appscreenStack = mainScene.callfunc("GetScreenStack", invalid)
        appscreenStack.screenNode = invalid
        appscreenStack.action = "Clear"
    else
        m.screenStack.screenNode = invalid
        m.screenStack.action = "Clear"
    end if
end sub

function GetCurrentScreen()
    ' Define a screen stack variable.
    appscreenStack = invalid
    if IsChildScreen()
        mainScene = m.top.GetScene()
        appscreenStack = mainScene.callfunc("GetScreenStack", invalid)
        return appscreenStack.current
    else
        return m.screenStack.current
    end if
end function

'''''''''
' CloseToHome: Close the screen stack until Home (GridScreen).
' 
'''''''''
function CloseToHome() as void
    ' Get the current screen.
    currentScreen = GetCurrentScreen()
    ' Close all screens until the GridScreen is reached.
    while not currentScreen.SubType() = "GridScreen"
        CloseScreen(currentScreen)
        currentScreen = GetCurrentScreen()
    end while
end function'//# sourceMappingURL=./ScreenStackLogic.bs.map