'import "pkg:/source/utils.bs"
'import "pkg:/components/UILogic/EpisodesOnlyScreenLogic.bs"
'import "pkg:/components/UILogic/SeasonsWithEpisodesScreenLogic.bs"
'import "pkg:/components/UILogic/VideoPlayer.bs"
'import "pkg:/components/UILogic/SubscriptionLogic.bs"
'import "pkg:/components/UILogic/ScreenStackLogic.bs"
'import "pkg:/components/UILogic/ContentVotingLogic.bs"
'import "pkg:/components/UILogic/Watched.bs"
'import "pkg:/components/UILogic/AudioScreenLogic.bs"





' Content voting buttons.




sub ShowDetailsScreen(content as Object, selectedItem as Integer)
    ' create new instance of details screen
    m.detailsScreen = CreateObject("roSGNode", "DetailsScreen")
    m.detailsScreen.content = content
    m.timeremainingLabel = m.detailsScreen.FindNode("timeremainingLabel")
    m.detailsScreen.jumpToItem = selectedItem ' set index of item which should be focused
    m.detailsScreen.ObserveField("visible", "OnDetailsScreenVisibilityChanged")
    m.detailsScreen.ObserveField("buttonSelected", "OnButtonSelected")
    ' Show the Details screen.
    ShowScreen(m.detailsScreen)
end sub

'''''''''
' OnButtonSelected: Handles a remote button press on a menu button.
' 
' @param {dynamic} I: event - the event object.
'''''''''
sub OnButtonSelected(event)
    details = event.GetRoSGNode()
    content = details.content
    ' Get the index of the selected button.
    buttonIndex = event.getData()
    m.detailsScreen.focusButton = buttonIndex
    ' Get the selected button text.
    buttonText = m.detailsScreen.callfunc("GetGroupButtonText", buttonIndex)
    ' If the button press was 'Like/Dislike', 'Liked' or 'Disliked', vote for content.
    if buttonText = "Like/Dislike" or buttonText = "Liked" or buttonText = "Disliked"
        feedItem = GetFeedItemFromContent(content, details.itemFocused)
        VoteForChannelContent(feedItem.id, feedItem.title)
    else
        ' Get the index of the selected content.
        selectedItem = details.itemFocused
        ' Get the video object associated with the content.
        videoObject = content.GetChild(selectedItem)
        ' Init some content flags.
        content.removeFields([
            "PlayAll"
        ])
        videoObject.removeFields([
            "Restart"
        ])
        videoObject.addFields({
            "Restart": false
        })
        ' Process PLAY button press.
        if buttonText = "Play"
            ' Reset the play start position.
            videoObject.PlayStart = 0.0
            ' Set content field to disable 'play all'.
            content.addFields({
                "PlayAll": false
            })
            ' Set content field to indicate 'restart' was not requested.
            videoObject.setFields({
                "Restart": false
            })
            HandlePlayButton(content, selectedItem)
            ' Process RESTART button press.
        else if buttonText = "Restart"
            ' Reset the play start position.
            videoObject.PlayStart = 0.0
            ' Set content field to disable 'play all'.
            content.addFields({
                "PlayAll": false
            })
            ' Set content field to indicate 'restart' was requested.
            videoObject.setFields({
                "Restart": true
            })
            HandlePlayButton(content, selectedItem)
            ' Process PLAYALL button press.
        else if buttonText = "Play all"
            ' Reset the play start position.
            videoObject.PlayStart = 0.0
            ' Set content field to disable 'play all'.
            content.addFields({
                "PlayAll": true
            })
            ' Set content field to indicate 'restart' was requested.
            videoObject.addFields({
                "Restart": true
                "selectedepisodeIndex": 0
            })
            if ContentIsType(videoObject, "series") AND SeriesHasSeasons(videoObject)
                videoObject.addFields({
                    "selectedseasonIndex": 0
                })
            end if
            HandlePlayButton(content, selectedItem)
            ' Process Episodes button press.
        else if buttonText = "Episodes"
            ' Retrieve the Series object from the content.
            series = GetFeedItemFromContent(content, selectedItem)
            ' Append its child Episodes.
            series = AppendEpisodesToSeriesNode(series, series.hasSeasons)
            ' create EpisodesScreen instance and show it.
            if series.hasSeasons = true
                ShowEpisodesScreen(series)
            else
                ShowEpisodesOnlyScreen(series)
            end if
            ' Process CONTINUE button press.
        else if buttonText = "Continue"
            HandlePlayButton(content, selectedItem)
        end if
    end if
end sub

sub OnDetailsScreenVisibilityChanged(event as Object) ' invoked when DetailsScreen "visible" field is changed    
    visible = event.GetData()
    detailsScreen = event.GetRoSGNode()
    currentScreen = GetCurrentScreen()
    screenType = currentScreen.SubType()
    ' update GridScreen's focus when navigate back from DetailsScreen
    if visible = false
        if screenType = "GridScreen"
            ' update GridScreen's focus when navigating back from DetailsScreen.
            currentScreen.jumpToRowItem = [
                m.selectedIndex[0]
                detailsScreen.itemFocused
            ]
        else if screenType = "EpisodesScreen"
            ' update EpisodesScreen's focus when navigating back from DetailsScreen.
            content = detailsScreen.content.GetChild(detailsScreen.itemFocused)
            currentScreen.jumpToItem = content.numEpisodes
        end if
    end if
end sub

'''''''''
' HandlePlayButton: Handles Play/OK button press.
' 
' @param {object} I: content - the content to play.
' @param {integer} I: selectedItem - index of the selected item.
'''''''''
sub HandlePlayButton(content as Object, selectedItem as Integer)
    ' Get the associated Season item.
    feedContent = GetFeedItemFromContent(content, selectedItem)
    ' If PlayAll has been requested, set the flag.
    if content.PlayAll <> invalid
        feedContent.removeFields([
            "PlayAll"
        ])
        feedContent.addFields({
            "PlayAll": content.PlayAll
        })
        if content.playAll = true
            selectedItem = 0
        end if
    end if
    seriesFlag = false
    ' Set the Series flag.
    if feedContent.mediaType = "series"
        seriesFlag = true
    end if
    ' If this content was previously 'watched', remove it's 'watched' bookmark.
    watchedBm = Watched()
    if watchedBm.HasBeenWatched(feedContent.id) = true
        watchedBm.DeleteBookmark(feedContent.id)
    end if
    if not IsAudioContent(feedContent)
        ' Play Video content.
        if m.global.useSubscriptions <> true
            ShowVideoScreen(feedContent, selectedItem, seriesFlag)
        else
            CheckSubscriptionAndStartPlayback(feedContent, selectedItem, seriesFlag)
        end if
    else
        ' Play Audio content.
        ShowAudioScreen(feedContent.url, feedContent.HDPosterUrl, feedContent.shortDescription)
    end if
    m.selectedIndex[1] = selectedItem ' store index of selected item
end sub

'''''''''
' VoteForChannelContent: Displays a dialog to vote for channel content.
' 
' @param {string} I: _contentId - the content ID.
' @param {string} I: _contentTitle - the title of the content.
' @return {dynamic}
'''''''''
function VoteForChannelContent(_contentId as string, _contentTitle as string)
    m.votingId = _contentId
    m.votingDialog = CreateObject("roSGNode", "ContentVotingDialog")
    m.votingDialog.callfunc("SetDialogTitle", _contentTitle)
    m.votingDialog.palette = CreateADialogPalette()
    m.votingDialog.observeFieldScoped("buttonSelected", "OnVotingButtonSelected")
    m.top.dialog = m.votingDialog
end function

'''''''''
' OnVotingButtonSelected: Event handler - Handles button click in the Voting dialog.
' 
' @return {dynamic}
'''''''''
function OnVotingButtonSelected()
    if m.votingDialog.buttonSelected = 0
        vote = "Like"
    else
        vote = "Dislike"
    end if
    m.votingDialog.close = true
    ' Start a task to pass the vote to the back end server.
    VoteForContent(m.votingId, vote, m.detailsScreen)
end function'//# sourceMappingURL=./DetailsScreenLogic.bs.map