'import "pkg:/components/UILogic/ScreenStackLogic.bs"



'''''''''
' GetSupportedMediaTypes: Gets the supported media types.
' 
' @return {object}
'''''''''
function GetSupportedMediaTypes() as Object ' returns AA with supported media types
    return {
        "series": "series"
        "season": "season"
        "episode": "episode"
        "movie": "movie"
        "shortFormVideo": "shortFormVideo"
    }
end function

'''''''''
' ValidateDeepLink: Validates the arguments that were passed.
' 
' @param {object} I: _args - the Deep link arguments.
' @return {boolean} - returns true if OK, else, false.
'''''''''
function ValidateDeepLink(_args as Object) as Boolean
    mediaType = _args.dl_mediaType
    contentId = _args.dl_id
    types = GetSupportedMediaTypes()
    return mediaType <> invalid and contentId <> invalid and types[mediaType] <> invalid
end function

'''''''''
' OnInputDeepLinking: Called when the scene input args is defined.
' 
' @param {object} I: event - the Deep link arguments.
'''''''''
sub OnInputDeepLinking(_event as Object) ' invoked in case of "roInputEvent"
    args = _event.getData()
    if args <> invalid and ValidateDeepLink(args) ' validate deep link arguments
        ' Make sure the content is valid before Deep Linking.
        if m.GridScreen.content <> invalid
            DeepLink(args) ' Perform deep linking
        end if
    end if
end sub

'''''''''
' DeepLink: Perform Deep Linking to show the video content.
' 
' @param {object} I: _args - the Deep Linking arguments.
'''''''''
sub DeepLink(_args as object) as void
    playableItem = CreateContentNodeFromRawObject(_args)
    ' Check for a valid playable item.  An item is typically not valid due to an invalid content id.
    if playableItem <> invalid
        ClearScreenStack() ' remove all screen from screen stack except GridScreen
        ' Show the video screen.
        ShowVideoScreen(playableItem, 0)
    else
        ' If code reaches this point, the content ID was not found.
        msg = []
        str = "The requested content ID '" + _args["dl_id"] + "' is not available."
        msg.Push(str)
        msg.Push("Please contact the channel developer.")
        buttons = []
        buttons.Push("Ok")
        m.Dialog = ShowAMessageDialog("Content Not Found", msg, buttons)
        m.Dialog.observeFieldScoped("buttonSelected", "onOk")
        ' display the dialog
        scene = m.top.getScene()
        scene.dialog = m.Dialog
    end if
end sub

'''''''''
' onOk: Handles click on the OK button.
' 
'''''''''
sub onOk()
    if m.Dialog.buttonSelected = 0
        ' handle ok button here
        m.Dialog.close = true
    end if
end sub'//# sourceMappingURL=./DeepLinkingLogic.bs.map