' (c) Copyright 2024, Michael Harnad
'import "pkg:/components/UILogic/VotingBookmarkLogic.bs"
' Content voting buttons.





'''''''''
' VoteForContent: Vote for content.
' 
' @param {string} I: _contentid - the id of the content.
' @param {string} I: _vote - the 'Like' or 'Dislike' vote.
' @param {object} I: _source - the source screen that generated the vote.
'''''''''
function VoteForContent(_contentid as string, _vote as string, _source as object) as void
    m.ContentVotingTask = CreateObject("roSGNode", "ContentVotingTask")
    m.votingTimer = m.ContentVotingTask.FindNode("votingTimer")
    m.ContentVotingTask.contentid = _contentid
    m.ContentVotingTask.vote = _vote
    m.ContentVotingTask.sourceNode = _source
    ' Watch the vote status.
    m.ContentVotingTask.ObserveField("status", "OnVoteHasBeenCast")
    ' Run the content voting task.
    m.ContentVotingTask.control = "run" ' VoteForContent in ContentVotingTask called here.
end function

'''''''''
' OnVoteHasBeenCast: Event handler - Handles processing the update to the 'status' field.
' 
'''''''''
function OnVoteHasBeenCast() as void
    ' Stop the voting task.
    m.ContentVotingTask.control = "stop"
    ' Get the source screen to generated the task.
    screenNode = m.ContentVotingTask.sourceNode
    nodeType = screenNode.SubType()
    if nodeType = "DetailsScreen"
        detailsButtons = screenNode.FindNode("detailsButtons")
        buttonNode = detailsButtons.getChild(detailsButtons.getChildCount() - 1)
        if m.ContentVotingTask.vote = "Like"
            buttonNode.text = "Liked"
            buttonNode.focusedIconUri = "pkg:/images/like.png"
        else
            buttonNode.text = "Disliked"
            buttonNode.focusedIconUri = "pkg:/images/dislike.png"
        end if
    else if nodeType = "EpisodesOnlyScreen" OR nodeType = "EpisodesScreen"
        episodesList = screenNode.FindNode("episodesList")
        episodes = episodesList.content.getChildren(- 1, 0)
        episode = episodes[episodesList.itemFocused]
        episode.removeFields([
            "vote"
        ])
        episode.AddFields({
            "vote": m.ContentVotingTask.vote
        })
    else
        return
    end if
    m.votingLabel = screenNode.FindNode("votingLabel")
    m.votingLabel.text = "<GothamWhite12>Thank you for your feedback</GothamWhite12>"
    m.votingLabel.visible = true
    ' Set a timer to remove the feedback message.
    m.votingTimer.ObserveField("fire", "OnTimerPop")
    m.votingTimer.control = "start"
end function

'''''''''
' OnTimerPop: Event handler - Handles timer pop event.
' 
'''''''''
function OnTimerPop() as void
    m.votingLabel.visible = false
end function

'''''''''
' RemoveVote: Removes a previously cast vote.
' 
' @param {dynamic} I: _contentID - the content ID of the vote to remove.
'''''''''
function RemoveVote(_contentID) as void
    voting = VotingBookmarkClass(_contentID, "")
    voting.DeleteBookmark(_contentID)
end function'//# sourceMappingURL=./ContentVotingLogic.bs.map