'''''''''
' LoadChannelContent: Loads the channel content by spawning a task to iterate the feed file.
' 
'''''''''
sub LoadChannelContent()
    m.ContentTask = CreateObject("roSGNode", "MainLoaderTask") ' create task for retrieving channel feed.
    ' observe content so we can know when the feed content will be parsed.
    m.contentTask.ObserveField("content", "OnMainContentLoaded")
    m.contentTask.control = "run" ' GetContent(see MainLoaderTask.brs) method is executed.
    m.loadingIndicator.visible = true ' show loading indicator while content is loading.
end sub

'''''''''
' OnMainContentLoaded: Event: called after the content feed has been loaded.
' 
'''''''''
sub OnMainContentLoaded() ' invoked when content has been parsed and is ready to use.
    m.GridScreen.SetFocus(true) ' set focus to the GridScreen.
    m.loadingIndicator.visible = false ' hide loading indicator because content was retrieved.
    m.spinner.visible = false
    m.GridScreen.content = m.contentTask.content ' populate GridScreen with content.
    ' Get the input args to check for Deeplinking invocation.
    args = m.top.inputArgs
    ' If the args are valid, invoke Deeplinking.
    if args <> invalid and ValidateDeepLink(args)
        DeepLink(args)
    end if
    m.contentTask.UnobserveField("content")
    m.contentTask.control = "stop"
end sub

'''''''''
' IsDuplicateIndexEntry: Checks for duplicate entries in the index that can result from playlists.
' 
' @param {object} I: _index - the content index.
' @param {string} I: _contentId - the content id to check for duplicates.
' @return {boolean} - returns true if duplicate, else, false.
'''''''''
function IsDuplicateIndexEntry(_index as object, _contentId as string) as boolean
    for each entry in _index
        if entry.id = _contentId
            return true
            exit for
        end if
    end for
    return false
end function'//# sourceMappingURL=./ContentTaskLogic.bs.map