' (c) Copyright 2025, Michael Harnad, all rights reserved.

'''''''''
' ShowAudioScreen: Shows the Audio playback screen.
' 
' @param {string} I: _mp3Url - the URL for the .mp3 audio file.
' @param {string} I: _mp3Thumbnail - the URL for a background image.
' @param {string} I: _description - the description of the audio stream.
'''''''''
sub ShowAudioScreen(_mp3Url as string, _mp3Thumbnail as string, _description as string)
    m.audioScreen = CreateObject("roSGNode", "AudioScreen")
    m.audioScreen.observeField("visible", "OnAudioScreenVisibilityChanged")
    ' Set some fields in the audioScreen.
    m.audioScreen.audioUrl = _mp3Url
    m.audioScreen.audioThumbnail = _mp3Thumbnail
    m.audioScreen.description = _description
    ' Get a refernce to the poster field and assign the image.
    m.audioPoster = m.audioScreen.findNode("audioPoster")
    m.audioPoster.uri = _mp3Thumbnail
    ' Get a refernece to the Audio object.
    m.audioPlayer = m.audioScreen.findNode("audioPlayer")
    ' Show the Audio screen.
    ShowScreen(m.audioScreen)
    ' Define the attributes of the Audio object and start streaming.
    audiocontent = createObject("RoSGNode", "ContentNode")
    audiocontent.url = _mp3Url
    m.audioPlayer.content = audiocontent
    m.audioPlayer.control = "play"
    m.audioPlayer.SetFocus(true)
end sub

'''''''''
' OnAudioScreenVisibilityChanged: Event handler - handles the change is screen visibiilty.
' 
' @param {object} I: _event - the screen visibility state.
'''''''''
sub OnAudioScreenVisibilityChanged(_event as object)
    isVisible = _event.GetData()
    if not isVisible
        m.audioPlayer.control = "stop"
    end if
end sub'//# sourceMappingURL=./AudioScreenLogic.bs.map