' (c) Copyright 2024, Michael Harnad


sub Init()
    ' Watch for changes in visibility.
    m.top.observeField("visible", "OnVisibleChanged")
    ' Get the reference to the main menu.
    m.mainMenu = m.top.FindNode("mainMenu")
    m.menuList = m.mainMenu.getChild(0)
    m.tagGrid = m.top.FindNode("tagPosterGrid")
    ' Build the tag grid.
    BuildTagGrid()
end sub

'''''''''
' OnVisibleChanged: Event handler - handles changes in screen visibility.
' 
' @param {object} I: _visibility - true if visible, else, false.
'''''''''
sub OnVisibleChanged(_visibility as object)
    isVisible = _visibility.GetData()
    if isVisible
        m.tagGrid.SetFocus(true)
    end if
end sub

'''''''''
' BuildTagGrid: Build the tag grid.
' 
'''''''''
function BuildTagGrid() as void
    tagArray = {}
    ' Collect all of the unique index tags.
    for each indexItem in m.global.ContentIndex
        if indexItem.tags <> invalid
            for each tag in indexItem.tags
                if not tagArray.DoesExist(tag)
                    tagArray[tag] = "0"
                end if
            end for
        end if
    end for
    gridRoot = CreateObject("roSGNode", "ContentNode")
    for each tag in tagArray
        tagChild = CreateObject("roSGNode", "ContentNode")
        tagChild.SHORTDESCRIPTIONLINE1 = tag
        tagChild.hdposterUrl = "pkg:/images/tags.png"
        gridRoot.appendChild(tagChild)
    end for
    m.tagGrid.content = gridRoot
    m.tagGrid.itemSelected = 0
    m.menuList.drawFocusFeedback = false
    m.tagGrid.SetFocus(true)
end function

'''''''''
' onKeyEvent: Event Handler - handles remote key presses.
' 
' @param {string} I: _key - key that was pressed.
' @param {boolean} I: _press - true if key was pressed, false if released.
' @return {boolean} - returns true if handled, else, false.
'''''''''
function onKeyEvent(_key as string, _press as boolean) as boolean
    handled = false
    ' If Left key press and the grid has focus...
    if _key = "left" and _press = true and m.tagGrid.hasFocus()
        m.menuList.itemSize = [
            150
            35
        ]
        m.menuList.jumpToItem = m.menuList.itemFocused
        m.menuList.drawFocusFeedback = true
        m.menuList.SetFocus(true)
        handled = true
    end if
    return handled
end function'//# sourceMappingURL=./TagScreen.bs.map