' (c) Copyright 2024, Michael Harnad
' Server types.

' Server resource database.

function __ServerResources_builder()
    instance = {}
    '''''''''
    ' new: Class constructor.
    ' 
    ' @param {serverType} I: _type - server type from enum.
    '''''''''
    instance.new = sub(_type as object)
        m._serverResJson = invalid
        if _type = 0
            m._serverResJson = ParseJson(ReadAsciiFile("pkg:/components/ServerResources/resources.json"))
        end if
    end sub
    '''''''''
    ' GetSubscriptionServerURL: Get the subscription server URL for the endpoint.
    ' 
    ' @param {string} I: _endpoint - the URL endpoint.
    ' @return {string} - returns the subscription server URL.
    '''''''''
    instance.GetSubscriptionServerURL = function(_endpoint as string) as string
        try
            for each server in m._serverResJson.servers
                if server.type = "subscription"
                    for each endpoint in server.endpoints
                        if endpoint["action"] = _endpoint
                            if endpoint["url"] <> ""
                                url = endpoint["url"]
                                exit for
                            else
                                THROW "Endpoint " + _endpoint + " not found in server resources."
                            end if
                        end if
                    end for
                end if
            end for
        catch excp
            THROW "Endpoint " + _endpoint + "not found in server resources."
        end try
        ' If a server URL was not found, throw an exception.
        if url = ""
            THROW "Server URL is missing."
        end if
        return url
    end function
    return instance
end function
function ServerResources(_type as object)
    instance = __ServerResources_builder()
    instance.new(_type)
    return instance
end function'//# sourceMappingURL=./ServerResources.bs.map