sub Init()
    ' Change the focus style so the the items do not go past the top or the end.
    m.top.vertFocusAnimationStyle = "floatingFocus"
end sub

''''''''
' OnKeyEvent: Event Handler: Handles remote key presses on the ButtonGroup.
' 
' @param {string} I: key - the key that as pressed.
' @param {boolean} I: press - flag to indicate a key press.
' @return {boolean} - returns true if this code handles the key press.
'''''''''
function OnKeyEvent(_key as string, _press as boolean) as boolean
    handled = false
    if _press = true
        ' UP key press.
        if _key = "up"
            if m.top.itemFocused = 0
                SetFocusToScreenControl("searchButtons")
                handled = true
            end if
        end if
        ' LEFT key press.
        if _key = "left"
            SetFocusToScreenControl("searchKeyboard")
            handled = true
        end if
    end if
    return handled
end function

'''''''''
' SetFocusToScreenControl: Sets the focus to the requested screen control.
' 
' @param {string} I: _controlName - name of the control to receive the focus.
'''''''''
function SetFocusToScreenControl(_controlName as string) as void
    ' Get the immediate parent.
    parent = m.top.getParent()
    while parent.subType() <> "SearchScreen"
        parent = parent.getParent()
    end while
    screenControl = parent.FindNode(_controlName)
    m.top.drawFocusFeedback = false
    screenControl.setFocus(true)
end function'//# sourceMappingURL=./SearchMarkupList.bs.map