'''''''''
' OnKeyEvent: Event Handler: Handles remote key presses on the ButtonGroup.
' 
' @param {string} I: key - the key that as pressed.
' @param {boolean} I: press - flag to indicate a key press.
' @return {boolean} - returns true if this code handles the key press.
'''''''''
function OnKeyEvent(_key as string, _press as boolean) as boolean
    handled = false
    if _press = true
        ' Get the number of buttons in the button group.
        numberOfButtonsInGroup = m.top.GetChildCount()
        ' RIGHT key press.
        if _key = "right"
            ' There must be more than one button in the group to process a right key press.
            if numberOfButtonsInGroup > 1
                'm.searchButtons.SetFocus(true)
                ' If the index is less than the number of buttons, process the right key press.
                if m.top.buttonFocused < numberOfButtonsInGroup - 1
                    m.top.focusButton = m.top.buttonFocused + 1
                    UpdateSearchResults(m.top.focusButton)
                    handled = true
                end if
            end if
        end if
        ' LEFT key press.
        if _key = "left"
            ' If the index is greater than the number of buttons, process the left key press.
            if m.top.buttonFocused > 0
                m.top.focusButton = m.top.buttonFocused - 1
                UpdateSearchResults(m.top.focusButton)
                handled = true
            else
                SetFocusToScreenControl("searchKeyboard")
                handled = true
            end if
        end if
        ' DOWN key press.
        if _key = "down"
            SetFocusToScreenControl("searchList")
            handled = true
        end if
    end if
    return handled
end function

'''''''''
' GetParentSearchScreen: Get the paren Search screen.
' 
' @return {object} - returns the parent Search screen object.
'''''''''
function GetParentSearchScreen() as object
    ' Get the immediate parent.
    parent = m.top.getParent()
    while parent.subType() <> "SearchScreen"
        parent = parent.getParent()
    end while
    return parent
end function

'''''''''
' SetFocusToScreenControl: Sets the focus to the requested screen control.
' 
' @param {string} I: _controlName - name of the control to receive the focus.
'''''''''
function SetFocusToScreenControl(_controlName as string) as void
    ' Get the Screen parent.
    parent = GetParentSearchScreen()
    screenControl = parent.FindNode(_controlName)
    if _controlName = "searchList"
        screenControl.drawFocusFeedback = true
    end if
    screenControl.setFocus(true)
end function

'''''''''
' UpdateSearchResults: Update the Search list based on the button index.
' 
' @param {integer} I: _index - index of the button.
'''''''''
function UpdateSearchResults(_index as integer) as void
    ' Get the Screen parent.
    parent = GetParentSearchScreen()
    parent.callfunc("ReloadSearchResults", _index)
end function'//# sourceMappingURL=./SearchButtonGroup.bs.map