

sub Init()
    ' store components to m for populating them with metadata
    m.poster = m.top.FindNode("poster")
    m.title = m.top.FindNode("title")
    m.description = m.top.FindNode("description")
    m.info = m.top.FindNode("info")
    ' set font size for title and description Labels
    m.title.font.size = 20
    m.description.font.size = 16
    m.info.font.size = 16
end sub

sub itemContentChanged() ' invoked when search data is retrieved
    itemContent = m.top.itemContent ' search metadata
    if itemContent <> invalid
        ' populate components with metadata
        m.poster.uri = itemContent.hdPosterUrl
        m.title.text = itemContent.title
        m.description.text = itemContent.longDescription
        if itemContent.mediaType = "series"
            if itemContent.hasSeasons = true
                m.info.text = "Series: " + itemContent.numSeasons.toStr() + " Seasons with " + itemContent.numEpisodes.toStr() + " Episodes."
            else
                m.info.text = "Series: " + itemContent.numEpisodes.toStr() + " Episodes."
            end if
        end if
    end if
end sub'//# sourceMappingURL=./SearchListItemComponent.bs.map