' (c) copyright 2024, Michael Harnad.  All rights reserved.
'import "pkg:/components/UILogic/ScreenStackLogic.bs"

sub Init()
    ' Define a screen stack.
    m.top.appscreenStack = []
    ' Save the screen stack to the temp file system.
    WriteAsciiFile("tmp:/screenstack.json", FormatJson(m.top.appscreenStack))
    ' Observe the action field to know when to perform stack operations.
    m.top.ObserveField("action", "OnDoAction")
end sub

'''''''''
' GetPreviousScreen: Gets the previous screen on the screen stack.
' 
' @param {object} I: _screenStack - the screen stack.
' @param {boolean} I: [_pop=false] - true to pop the screen off the stack, else, false.
' @return {object} - returns the screen node.
'''''''''
function GetPreviousScreen(_screenStack as object, _pop = false as boolean) as object
    ' Initialize previous screen.
    prevScreen = invalid
    ' Get the name of the previous screen.
    prevscreenName = _screenStack[_screenStack.Count() - 1]
    ' Get the children of the Main Scene.
    mainSceneChildren = m.top.GetParent().GetChildren(- 1, 0)
    ' For each child, look for the previous screen.
    for each child in mainSceneChildren
        if prevscreenName = child.SubType()
            prevScreen = child
        end if
    end for
    ' Pop the stack?
    if _pop = true
        _screenStack.Pop()
    end if
    return prevScreen
end function

function OnDoAction()
    ' Get the screen stack from the temp file system.
    appscreenStack = ParseJson(ReadAsciiFile("tmp:/screenstack.json"))
    ' Show a screen.
    if m.top.Action = "Show"
        prev = invalid
        screenCount = appscreenStack.Count()
        if screenCount > 0
            prev = GetPreviousScreen(appscreenStack)
            prev.visible = false
        end if
        ' show new screen.
        m.top.GetParent().AppendChild(m.top.screenNode)
        m.top.screenNode.visible = true
        m.top.screenNode.SetFocus(true)
        ' Save the screen to the stack.
        screenName = m.top.screenNode.SubType()
        appscreenStack.Push(screenName)
        ' Save the current screen.
        m.top.current = m.top.screenNode
        ' Close a screen.   
    else if m.top.Action = "Close"
        numberOfScreensOnStack = appscreenStack.Count()
        if numberOfScreensOnStack > 1
            if m.top.screenNode = invalid OR (appscreenStack.Count() > 0 AND GetPreviousScreen(appscreenStack).IsSameNode(m.top.screenNode))
                last = GetPreviousScreen(appscreenStack, true)
                last.visible = false ' hide screen.
                m.top.GetParent().RemoveChild(m.top.screenNode) ' remove screen from scene.
                ' take previous screen and make it visible.
                prev = GetPreviousScreen(appscreenStack)
                if prev <> invalid
                    prev.visible = true
                    prev.SetFocus(true)
                    m.top.current = prev
                end if
            end if
        end if
        ' Clear the screen stack.
    else if m.top.Action = "Clear"
        if appscreenStack.Count() > 1
            while appscreenStack.Count() > 1
                last = GetPreviousScreen(appscreenStack, true)
                if last.visible = true
                    last.visible = false ' hide screen
                end if
                m.top.GetParent().RemoveChild(last)
            end while
            m.top.current = invalid
        else
            currentScreen = GetPreviousScreen(appscreenStack)
            currentScreen.visible = false
        end if
    end if
    ' Write the screen stack to the temp file system.
    m.top.appscreenStack = appscreenStack
    WriteAsciiFile("tmp:/screenstack.json", FormatJson(m.top.appscreenStack))
end function'//# sourceMappingURL=./ScreenStack.bs.map