' entry point of EpisodesListItemComponent
' (c) Copyright 2024, Michael Harnad, all rights reserved.
'import "pkg:/source/Theme.bs"
'import "pkg:/components/UILogic/BookmarkLogic.bs"
'import "pkg:/components/UILogic/Watched.bs"
'import "pkg:/source/utils.bs"


'''''''''
' Init: Initializes this component.
' 
'''''''''
sub Init()
    ' Save a reference to the Theme object.
    m.theme = Theme(m.top.SubType())
    ' Define the components of the progress component.
    m.progressBase = m.top.findNode("progressBase")
    m.progressIndicator = m.top.findNode("progressIndicator")
    m.watchedInidcatorColor = m.theme.GetObjectColor(m.progressIndicator)
    m.timeRemaining = m.top.findNode("timeRemaining")
    m.theme.SetFont(m.timeRemaining)
    m.restartPoster = m.top.findNode("restartThumbnail")
    m.restartPoster.uri = "pkg:/images/restart white.png"
    m.restart = m.top.findNode("restart")
    m.theme.SetFont(m.restart)
    m.restart.text = m.theme.FormatText(m.restart, "to restart")
    ' Get a Video bookmark.
    m.videoBookmark = Bookmark()
    ' Get a Watched bookmark.
    m.watchedBookmark = Watched()
end sub

'''''''''
' onContentChanged: Event handler - handles change in content.
' 
' @param {object} I: eventArg - the content object.
'''''''''
sub onContentChanged(eventArg as object)
    ' Get the content object.
    content = eventArg.GetData()
    ' If it's a Series object, do not display a progress indicator.  The indivual
    ' Episodes will show a progress indicator.
    if content.mediaType = "series"
        m.progressBase.visible = false
        return
    end if
    lastVideoPosition = m.videoBookmark.GetLastVideoPosition(content.id)
    ' If content has not been previously played, hide the progress indicator.
    if m.watchedBookmark.HasBeenWatched(content.id)
        SetWatchedIndicator(0)
    else if lastVideoPosition = 0
        m.progressBase.visible = false
        m.progressIndicator.visible = false
        m.restartPoster.visible = false
        m.restart.visible = false
    else
        bShow = true
        parentNode = GetParentNode()
        position = []
        remainingTime = []
        m.progressBase.visible = true
        m.progressIndicator.visible = true
        m.progressIndicator.color = "0xFFFFFF"
        m.timeRemaining.visible = true
        if parentNode = "DetailsScreen" or parentNode = invalid
            bShow = false
        end if
        m.restartPoster.visible = bShow
        m.restart.visible = bShow
        try
            position[0] = lastVideoPosition
            percentWatched = lastVideoPosition / content.length
            newWidth = m.progressBase.width * percentWatched
            m.progressIndicator.width = newWidth
            remainingTime[0] = GetTimeRemaining(content.length, position)
            m.timeRemaining.text = m.theme.FormatText(m.timeRemaining, remainingTime[0])
        catch excp
            message = []
            message[0] = excp.message
            buttons = []
            buttons[0] = "Ok"
            ShowAMessageDialog("Exception", message, buttons)
        end try
    end if
end sub

'''''''''
' onWidthChanged: Event handler - handles change in the component width.
' 
' @param {object} I: eventArg - the component width.
'''''''''
sub onWidthChanged(eventArg as object)
    width = eventArg.GetData()
    m.progressBase.width = width
end sub

'''''''''
' onHeightChanged: Event handler = handles change in the component height.
' 
' @param {object} I: eventArg - the component height.
'''''''''
sub onHeightChanged(eventArg as object)
    height = eventArg.GetData()
    m.progressBase.height = height
    m.progressIndicator.height = height
end sub

'''''''''
' GetParentNode: Gets the parent node.
' 
' @return {string} - returns the name of the parent node.
'''''''''
function GetParentNode() as string
    parents = {
        "DetailsScreen": "parent"
        "EpisodesListItemComponent": "parent"
    }
    try
        parent = m.top.getParent()
        subT = parent.SubType()
        while parents.DoesExist(subT) = false
            parent = parent.getParent()
            subT = parent.SubType()
        end while
    catch e
        subT = invalid
    end try
    return subT
end function

'''''''''
' SetWatchedIndicator: Sets an indicator showing that the content has
'                       been previoulsy watched.
' 
' @param {dynamic} _param - not used.
'''''''''
function SetWatchedIndicator(_param as dynamic) as void
    if m.global.WATCHED_INDICATOR
        m.timeRemaining.visible = false
        m.progressBase.visible = true
        m.progressIndicator.visible = true
        m.progressIndicator.width = m.progressBase.width
        m.progressIndicator.color = m.watchedInidcatorColor
    endif
end function'//# sourceMappingURL=./ProgressComponent.bs.map