'import "pkg:/components/UILogic/ScreenStackLogic.bs"
'import "pkg:/components/UILogic/CleanupLogic.bs"
'import "pkg:/components/UILogic/InputLogic.bs"
'import "pkg:/components/RokuVoice/Voice.bs"
'import "pkg:/source/Theme.bs"


' entry point of MainScene
sub Init()
    ' Save a reference to the Theme object.
    m.theme = Theme(m.top.SubType())
    ' Get the custom attributes and assign them to the global node.
    GetCustomAttributes()
    ' Set background color for scene.  Applied only if backgroundUri has empty value.
    m.top.backgroundColor = m.global.BACKGROUND_COLOR
    backgroundImage = m.global.BACKGROUND_IMAGE
    ' If background image is supplied, use it.
    if backgroundImage <> ""
        m.background = m.top.findNode("background")
        m.background.uri = backgroundImage
    else
        m.top.backgroundUri = ""
    end if
    m.loadingIndicator = m.top.FindNode("loadingIndicator") ' store loadingIndicator to m
    m.theme.SetFont(m.loadingIndicator)
    loadingText = m.theme.GetObjectText("loadingIndicator", "loadingIndicator")
    m.loadingIndicator.text = m.theme.FormatText(m.loadingIndicator, loadingText)
    ' Create an Input task.
    m.inputTask = StartInputTask()
    ' Define an event handler for the Input task.
    m.inputTask.Observefield("inputData", "HandleInputEvent")
    ' Start the input task.
    m.inputTask.control = "run"
    ' Run cleanup tasks.
    Cleanup()
    ' Initialize the screen stack.
    InitScreenStack()
    ' Show the grid screen.
    ShowGridScreen()
    ' Collect the content from the feed file.
    LoadChannelContent()
    ' Display 'busy' animation.
    m.spinner = m.top.findNode("busySpinner")
    m.spinner.poster.observeField("loadStatus", "OnShowSpinner")
    m.spinner.poster.uri = "pkg:/images/busyspinner_hd.png"
    ' Create a ChannelStore object and attach it to the global node.
    m.global.AddField("channelStore", "node", false)
    m.global.channelStore = CreateObject("roSGNode", "ChannelStore")
    ' DEBUG ONLY - Remove Roku cloud token.
    'm.global.channelStore.channelCredData = ""
    'm.global.channelStore.command = "storeChannelCredData"
    ' DEBUG ONLY
end sub

'''''''''
' OnShowSpinner: Event handler - process spinner load status.
' 
'''''''''
sub OnShowSpinner()
    if m.spinner.poster.loadStatus = "ready"
        centerx = (1280 - m.spinner.poster.bitmapWidth) / 2
        centery = (720 - m.spinner.poster.bitmapHeight) / 2
        m.spinner.translation = [
            centerx
            centery
        ]
        m.spinner.visible = "true"
    end if
end sub

'   The OnKeyEvent() function receives remote control key events.
function OnKeyEvent(key as String, press as Boolean) as Boolean
    result = false
    if press
        ' handle "back" key press.
        if key = "back"
            numberOfScreens = m.ScreenStack.appscreenStack.Count()
            ' close top screen if there are two or more screens in the screen stack.
            if numberOfScreens > 1
                CloseScreen(invalid)
                result = true
            end if
        end if
    end if
    ' The OnKeyEvent() function must return true if the component handled the event,
    ' or false if it did not handle the event.
    return result
end function

'''''''''
' GetScreenStack: Gets the screen stack componenet in those situations where the 'm' context is incorrect.
' 
' @param {dynamic} I: _parm - needed by callfunc().
' @return {object} - returns the screen stack component.
'''''''''
function GetScreenStack(_parm as dynamic) as object
    return m.screenStack
end function

'''''''''
' HandleInputEvent: Handles input events and passes them on to the appropriate handler.
' 
' @param {object} I: _event - the input event object.
'''''''''
function HandleInputEvent(_event as object) as void
    if type(_event) = "roSGNodeEvent" and _event.getField() = "inputData"
        inputData = _event.getData()
        if inputData <> invalid
            if inputData.type = "deeplink"
                SaveDeepLinkingArgs(m.top, inputData)
            else
                ret = HandleRokuVoiceCommand(inputData)
                m.InputTask.transportResponse = {
                    id: inputData.id
                    status: ret
                }
            end if
        end if
    end if
end function'//# sourceMappingURL=./MainScene.bs.map