' (c) Copyright 2024, Michael Harnad
'import "pkg:/components/UILogic/SearchScreenLogic.bs"
'import "pkg:/components/UILogic/TagScreenLogic.bs"
'import "pkg:/components/UILogic/ScreenStackLogic.bs"

'''''''''
' Init: Initializes this component.
' 
'''''''''
sub Init()
    ' Read the main menu items.
    mainMenuItems = ParseJson(ReadAsciiFile("pkg:/source/main_menu.json"))
    ' Get reference to main menu list.
    m.mainMenuList = m.top.findNode("mainMenuList")
    m.mainMenuList.itemSelected = 0
    m.mainMenuList.observeField("itemSelected", "OnMenuItemSelected")
    ' Build the main menu.
    BuildMainMenu(mainMenuItems)
end sub

'''''''''
' BuildMainMenu: Builds the main menu component.
' 
'''''''''
function BuildMainMenu(_mainMenu as object) as void
    ' Initialize the menu action array.
    m.menuActionArray = []
    ' Get the Roku device display size.
    rokuSize = GetRokuDisplaySize()
    halfScreenHeight = rokuSize["h"] / 2
    ' Set the location of the menu based on the Roku device resolution.
    menuHeight = m.mainMenuList.translation[1]
    halfMenuHeight = menuHeight / 2
    topMenulist = halfScreenHeight - halfMenuHeight
    m.mainMenuList.translation[1] = topMenulist
    ' Create the main menu root.
    mainMenuRoot = CreateObject("roSGNode", "ContentNode")
    for each menuItem in _mainMenu.MainMenuItems
        ' Ensure that the menu item is enabled.
        if menuItem["enabled"]
            m.menuActionArray.Push(menuItem["action"])
            mainmenuItem = CreateObject("roSGNode", "ContentNode")
            mainmenuItem.title = menuItem["title"]
            mainmenuItem.HDPosterUrl = menuItem["bitmap"]
            mainMenuRoot.appendChild(mainmenuItem)
        end if
    end for
    ' Populate the menu items in the markuplist.
    m.mainMenuList.content = mainMenuRoot
    m.mainMenuList.drawFocusFeedback = false
end function

'''''''''
' OnMenuItemSelected: 
' 
' @param {object} _itemSelected
'''''''''
sub OnMenuItemSelected(_itemSelected as object) as void
    menuSelection = _itemSelected.GetData()
    menuAction = m.menuActionArray[menuSelection]
    m.mainMenuList.itemFocused = menuSelection
    ' If the menu list has the focus...
    if m.mainMenuList.hasFocus()
        ' User has selected the Home menu item.
        if menuAction = "MENU_HOME"
            CloseToHome()
        else if menuAction = "MENU_TAGS"
            SlideScreenLeft()
            ShowTagsScreen()
            ' User has selected the Search menu item.
        else if menuAction = "MENU_SEARCH"
            SlideScreenLeft()
            ShowSearchScreen()
            ' User has selected the Series menu item.
        else if menuAction = "MENU_SERIES"
            selectedTagContentArray = BuildArrayOfMediaTypes("series")
            SlideScreenLeft()
            ShowTagContentScreen(selectedTagContentArray)
            ' User has selected the Movies menu item.
        else if menuAction = "MENU_MOVIES"
            selectedTagContentArray = BuildArrayOfMediaTypes("movies")
            SlideScreenLeft()
            ShowTagContentScreen(selectedTagContentArray)
        end if
    end if
end sub

'''''''''
' onKeyEvent: Event handler - handles remote key presses.
' 
' @param {string} I: _key - key that was pressed.
' @param {boolean} I: _press - true if key was pressed, false if released.
' @return {boolean} - returns true if handled, else, false.
'''''''''
function onKeyEvent(_key as string, _press as boolean) as boolean
    handled = false
    ' If Right key press and the menu list has focus...
    if _key = "right" and _press = true and m.mainMenuList.hasFocus() = true
        SlideScreenLeft()
        handled = true
    end if
    return handled
end function

'''''''''
' SlideScreenLeft: Slide the screen to the Left by setting some attributes.
' 
'''''''''
function SlideScreenLeft() as void
    ' Get the parent screen.
    parentScreen = m.top.getParent().getParent()
    ' Grid Screen.
    if parentScreen.subtype() = "GridScreen"
        ' Get the Grid rowlist.
        rowList = parentScreen.FindNode("rowList")
        rowList.SetFocus(true)
        ' Tags Screen.
    else if parentScreen.subtype() = "TagsScreen"
        ' Get the Grid tag array.
        gridArray = parentScreen.FindNode("tagPosterGrid")
        gridArray.SetFocus(true)
        ' Tag content screen.
    else if parentScreen.subtype() = "TagContentScreen"
        gridArray = parentScreen.FindNode("TagContentGrid")
        gridArray.SetFocus(true)
    end if
    ' Remove the focus bitmap.
    m.mainMenuList.drawFocusFeedback = false
    ' Resize the menu.
    m.mainMenuList.itemSize = [
        35
        35
    ]
end function'//# sourceMappingURL=./MainMenuComponent.bs.map