'import "pkg:/source/Theme.bs"

' entry point of EpisodesScreen
function Init()
    ' Save a reference to the Theme object.
    m.theme = Theme(m.top.SubType())
    m.episodesList = m.top.FindNode("episodesList")
    ' Extras label.
    m.extrasLabel = m.top.FindNode("extrasLabel")
    m.theme.SetFont(m.extrasLabel)
    ' Credits label.
    m.creditsLabel = m.top.FindNode("creditsLabel")
    m.theme.SetFont(m.creditsLabel)
    ' voting label.
    m.votingLabel = m.top.FindNode("votingLabel")
    m.theme.SetFont(m.votingLabel)
    m.votingLabel.visible = false
    ' voting timer.
    m.votingTimer = m.top.FindNode("votingTimer")
    ' observe "visible" so we can know when EpisodesScreen change visibility
    m.top.ObserveField("visible", "onVisibleChange")
    ' observe "itemSelected" so we can know which episode is selected
    m.episodesList.ObserveField("itemSelected", "OnEpisodeListItemSelected")
    m.top.ObserveField("content", "OnEpisodeContentChange")
    ' Get the Content Voting flag.
    m.contentVoting = m.global.CONTENT_VOTING
end function

sub onVisibleChange() ' invoked when Episodes screen becomes visible
    if m.top.visible = true
        m.episodesList.jumpToItem = m.top.selectedItem
        m.episodesList.setFocus(true) ' set focus to the episodes list
    end if
end sub

sub OnEpisodeListItemSelected(event as Object) ' invoked when episode is selected
    itemSelected = event.GetData() ' index of selected item
    m.top.selectedItem = itemSelected
end sub

sub OnJumpToItem(event as Object) ' invoked when "jumpToItem field is changed
    itemIndex = event.GetData()
    m.episodesList.jumpToItem = itemIndex ' navigate to the specified item
end sub

'''''''''
' SetSeriesCredits: Sets the Series Credits.
' 
' @param {object} I: _content - the Series content.
' @return {dynamic}
'''''''''
function SetSeriesCredits(_content as object)
    m.creditsLabel.text = ""
    if _content.actors <> invalid and _content.actors.Count() > 0
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, chr(62504), 1)
        actorsText = "Actors: "
        for each actor in _content.actors
            actorsText += actor + " "
        end for
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, actorsText)
    end if
    if _content.directors <> invalid and _content.directors.Count() > 0
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, chr(62504), 1)
        directorsText = "Directors: "
        for each director in _content.directors
            directorsText += director + " "
        end for
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, directorsText)
    end if
    if _content.narrators <> invalid and _content.narrators.Count() > 0
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, chr(62504), 1)
        narratorsText = "Narrators: "
        for each narrator in _content.narrators
            narratorsText += narrator + " "
        end for
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, narratorsText)
    end if
    if _content.producers <> invalid and _content.producers.Count() > 0
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, chr(62504), 1)
        producersText = "Producers: "
        for each producer in _content.producers
            producersText += producer + " "
        end for
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, producersText)
    end if
    if _content.hosts <> invalid and _content.hosts.Count() > 0
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, chr(62504), 1)
        hostsText = "Hosts: "
        for each host in _content.hosts
            hostsText += host + " "
        end for
        m.creditsLabel.text += m.theme.FormatText(m.creditsLabel, hostsText)
    end if
end function

'''''''''
' OnEpisodeContentChange: Called when the content is changed.
' 
'''''''''
sub OnEpisodeContentChange()
    ' Establish Episode content.
    content = m.top.content
    ' Set the thumbnail of the first episode.
    m.top.FindNode("seriesThumbnail").uri = content.hdPosterUrl
    ' Populate the list of Episodes in the MarkupList.
    m.episodesList.content = content
    m.extrasLabel.text = m.theme.FormatText(m.extrasLabel, content.numEpisodes.toStr() + " Episodes")
    m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, chr(62504), 1)
    if content.genres <> invalid
        for each genre in content.genres
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, genre)
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, chr(62504), 1)
        end for
    end if
    SetSeriesCredits(content)
end sub

'''''''''
' GetCurrentSelectedEpisode: Get the currently selected Episode.
' 
' @return {object} - returns the selected Episode.
'''''''''
function GetCurrentSelectedEpisode() as object
    ' Get the Series object.
    series = m.top.content
    ' Get the Episodes attached to the Series.
    episodes = series.GetChildren(- 1, 0)
    selectedEpisode = episodes[m.episodesList.itemFocused]
    return selectedEpisode
end function

' The OnKeyEvent() function receives remote control key events
function OnKeyEvent(key as String, press as Boolean) as Boolean
    result = false
    if press
        ' Look for Options press to display full text.
        if key = "options"
            ' Get the Series object.
            series = m.top.content
            ' Get the Episodes attached to the Series.
            episodes = series.GetChildren(- 1, 0)
            'selectedEpisode = episodes[m.episodesList.itemFocused]
            selectedEpisode = GetCurrentSelectedEpisode()
            description = []
            description.Push(selectedEpisode.longDescription)
            if selectedEpisode.Actors <> invalid and selectedEpisode.Actors.Count() > 0
                for each actor in selectedEpisode.Actors
                    description.Push("Actor: " + actor)
                end for
            end if
            if selectedEpisode.Hosts <> invalid and selectedEpisode.Hosts.Count() > 0
                for each host in selectedEpisode.Hosts
                    description.Push("Host: " + host)
                end for
            end if
            if selectedEpisode.Narrators <> invalid and selectedEpisode.Narrators.Count() > 0
                for each narrator in selectedEpisode.Narrators
                    description.Push("Narrator: " + narrator)
                end for
            end if
            if selectedEpisode.Directors <> invalid and selectedEpisode.Directors.Count() > 0
                for each director in selectedEpisode.Directors
                    description.Push("Director: " + director)
                end for
            end if
            if selectedEpisode.Producers <> invalid and selectedEpisode.Producers.Count() > 0
                for each producer in selectedEpisode.Producers
                    description.Push("Producer: " + producer)
                end for
            end if
            ' Set the dialog button(s).
            if m.contentVoting = invalid OR m.contentVoting = false
                m.descriptionDialog = CreateMessageDialog(episodes[m.episodesList.itemFocused].title, description, [
                    "Ok"
                ])
            else
                m.descriptionDialog = CreateMessageDialog(episodes[m.episodesList.itemFocused].title, description, [
                    "Like"
                    "Dislike"
                ])
            end if
            m.descriptionDialog.palette = CreateADialogPalette()
            ' observe the dialog's buttonSelected field to handle button selections
            m.descriptionDialog.observeFieldScoped("buttonSelected", "onOptionVoteButtonSelected")
            ' display the dialog
            scene = m.top.getScene()
            scene.dialog = m.descriptionDialog
            result = true
            ' Look for 'replay'/'restart' key.
        else if key = "replay"
            ' Get the currently focused Episode.
            episode = m.episodesList.content.getChild(m.episodesList.itemFocused)
            ' Set the restart flag.
            episode.addFields({
                "restart": true
            })
            ' Remove the Episode bookmark, so that the playback restarts.
            episodeBookmark = Bookmark()
            episodeBookmark.DeleteBookmark(episode.id)
            ' Trigger the playback.
            m.top.selectedItem = m.episodesList.itemFocused
            result = true
        end if
    end if
    return result
end function

'''''''''
' onOptionVoteButtonSelected: Handles vote button click on the Description Dialog.
' 
'''''''''
sub onOptionVoteButtonSelected()
    m.descriptionDialog.close = true
    if m.contentVoting = "true"
        episodes = m.top.content.GetChildren(- 1, 0)
        selectedEpisode = episodes[m.episodesList.itemFocused]
        VoteForContent(selectedEpisode.id, m.descriptionDialog.buttons[m.descriptionDialog.buttonSelected], m.top)
    end if
end sub'//# sourceMappingURL=./EpisodesOnlyScreen.bs.map