' entry point of EpisodesListItemComponent
'import "pkg:/source/Theme.bs"
'import "pkg:/components/UILogic/Watched.bs"

sub Init()
    ' Save a reference to the Theme object.
    m.theme = Theme(m.top.SubType())
    ' Create a Watched object.
    m.watchedBm = Watched()
    ' store components to m for populating them with metadata
    m.poster = m.top.FindNode("poster")
    m.title = m.top.FindNode("title")
    m.theme.SetFont(m.title)
    m.description = m.top.FindNode("description")
    m.theme.SetFont(m.description)
    m.info = m.top.FindNode("info")
    m.theme.SetFont(m.info)
    ' Progress indicator.
    m.progress = m.top.FindNode("progress")
    m.progress.height = 5
    m.progress.width = 310
end sub

sub itemContentChanged() ' invoked when episode data is retrieved
    itemContent = m.top.itemContent ' episode metadata
    if itemContent <> invalid
        ' Trigger an update of the progress component.
        m.progress.itemContent = itemContent
        ' populate components with metadata
        m.poster.uri = itemContent.hdPosterUrl
        m.title.text = m.theme.FormatText(m.title, itemContent.title)
        divider = " | "
        episode = "E" + itemContent.episodePosition
        time = GetTime(itemContent.length)
        date = itemContent.releaseDate
        m.info.text = m.theme.FormatText(m.info, episode + divider + date + divider + time)
        vote = []
        if VoteHasBeenCast(itemContent.id, vote) = true
            ' Add a 'vote' field if it does not exist.
            if itemContent.vote = invalid
                itemContent.addFields({
                    "vote": ""
                })
            end if
            itemContent.vote = vote[0]
        end if
        if itemContent.vote <> invalid
            if itemContent.vote = "Like"
                m.info.text += m.theme.FormatText(m.info, divider + "Liked")
            else
                m.info.text += m.theme.FormatText(m.info, divider + "Disliked")
            end if
        end if
        m.description.text = m.theme.FormatText(m.description, itemContent.description)
    end if
end sub

'''''''''
' OnItemFocused: Event Handler - handles item focused.
' 
' @param {object} _focus
'''''''''
sub OnItemFocused(_focus as object)
    itemFocused = _focus.GetData()
    if itemFocused
        itemContent = m.top.itemContent ' episode metadata
        if itemContent <> invalid
            ' Trigger an update of the progress component.
            m.progress.itemContent = itemContent
        end if
    end if
end sub'//# sourceMappingURL=./EpisodesListItemComponent.bs.map