'import "pkg:/source/Theme.bs"
'import "pkg:/source/utils.bs"


' entry point of detailsScreen
function Init()
    ' Save a reference to the Scene.
    m.mainScene = m.top.getScene()
    ' Save a reference to the Theme object.
    m.theme = Theme(m.top.SubType())
    ' Create a Watched object.
    m.watchedBm = Watched()
    ' Get the Content Voting flag.
    m.contentVoting = m.global.CONTENT_VOTING
    m.currentVote = "no vote"
    ' observe "visible" so we can know when DetailsScreen change visibility
    m.top.ObserveField("visible", "OnVisibleChange")
    ' observe "itemFocused" so we can know when another item gets in focus
    m.top.ObserveField("itemFocused", "OnItemFocusedChanged")
    ' observe "buttonFocused" so we can know when a button is focused.
    m.top.ObserveField("buttonFocused", "OnButtonFocused")
    ' save a references to the DetailsScreen child components in the m variable
    ' so we can access them easily from other functions
    ' details buttons.
    m.detailsButtons = m.top.FindNode("detailsButtons")
    m.buttonTextColors = {}
    SetButtonFont()
    ' poster.
    m.poster = m.top.FindNode("contentThumbnail")
    ' title label.
    m.titleLabel = m.top.FindNode("titleLabel")
    m.theme.SetFont(m.titleLabel)
    ' description label.
    m.description = m.top.FindNode("descriptionLabel")
    m.theme.SetFont(m.description)
    ' extras label.
    m.extrasLabel = m.top.FindNode("extrasLabel")
    m.theme.SetFont(m.extrasLabel)
    ' progress indicator.
    m.progress = m.top.FindNode("progress")
    m.progress.height = 5
    m.progress.width = m.detailsButtons.maxWidth
    ' voting label.
    m.votingLabel = m.top.FindNode("votingLabel")
    m.theme.SetFont(m.votingLabel)
    m.votingLabel.visible = false
    ' voting timer.
    m.votingTimer = m.top.FindNode("votingTimer")
    m.buttonIndex = 0
end function

sub OnVisibleChange() ' invoked when DetailsScreen visibility is changed
    ' Check to see if DetailsScreen is not visible.
    if m.top.visible = true
        position = [
            0.0
        ]
        remainingStr = []
        feedItem = GetFeedItemFromContent(m.top.content, m.top.itemFocused)
        ' Don't check for remaining time if the content object is a Series.
        if ContentIsType(feedItem, "series") = false
            ' Check if the video can be continued.
            videoCanBeContinued = ContentCanBeContinued(m.top.content, position, remainingStr)
            ' If the video can be continued, update the button group for Continue/Restart.
            if videoCanBeContinued = true
                SetDetailButtons([
                    "continueButton"
                    "restartButton"
                ])
                ' Set the content for the progress indicator.
                m.progress.itemContent = feedItem
            else if position[0] = 0 AND not VideoHasBeenWatched(feedItem.id)
                ' Update the button group for Play.
                SetDetailButtons([
                    "playButton"
                ])
            else
                ' Indicate that this content has been watched.
                m.progress.callfunc("SetWatchedIndicator", invalid)
                ' Update the button group for Play.
                SetDetailButtons([
                    "playButton"
                ])
            end if
        end if
        ' set focus for buttons list when DetailsScreen become visible
        m.detailsButtons.SetFocus(true)
    end if
end sub

'''''''''
' OnButtonFocused: Event handler - Invoked when a button is focused.
' 
' @param {object} event
'''''''''
sub OnButtonFocused(event as object)
    m.buttonIndex = event.GetData()
end sub

'''''''''
' SetButtonFont: Set the font for the Details button group.
' 
' @return {dynamic}
'''''''''
function SetButtonFont() as void
    m.detailsTextfont = m.theme.SetButtonFont(m.detailsButtons, m.buttonTextColors)
    m.detailsButtons.textFont = m.detailsTextfont
    m.detailsFocusedTextfont = m.theme.SetButtonFont(m.detailsButtons, m.buttonTextColors)
    m.detailsButtons.focusedTextFont = m.detailsFocusedTextfont
end function

'''''''''
' GetGroupButtonText: Get the group button text.
' 
' @param {integer} I: _index - index of the button to get.
' @return {string} - returns the button text if the index is valid.
'''''''''
function GetGroupButtonText(_index as integer) as string
    if _index < m.detailsButtons.getChildCount()
        button = m.detailsButtons.getChild(_index)
        return button.text
    else
        return ""
    end if
end function

'''''''''
' AddButtonToGroup: Adds a button to the button group.
' 
' @param {dynamic} I: _buttonName - the name of the button.
'''''''''
function AddButtonToGroup(_buttonName) as void
    button = CreateObject("roSGNode", "Button")
    button.text = m.theme.GetObjectText("detailsButtons", _buttonName)
    button.focusedIconUri = m.theme.GetObjectImage("detailsButtons", _buttonName)
    button.textFont = m.detailsTextfont
    button.textColor = m.buttonTextColors["textColor"]
    button.focusedTextColor = m.buttonTextColors["focusedTextColor"]
    button.focusedTextFont = m.detailsFocusedTextfont
    m.detailsButtons.AppendChild(button)
end function

'''''''''
' SetDetailButtons: Sets the button set the for the Details screen.
' 
' @param {object} I: _buttons - array of button text.
'''''''''
function SetDetailButtons(_buttons as object) as void
    ' Get the current child buttons.
    buttonChildren = m.detailsButtons.getChildren(- 1, 0)
    ' Remove the prior buttons from the Group if there are any,
    if buttonChildren.Count() > 0
        m.detailsButtons.removeChildren(buttonChildren)
    end if
    ' For each button in the button array, add a child button node to the group.
    for each buttonName in _buttons
        AddButtonToGroup(buttonName)
    end for
    ' Add the Like/Dislike button if required.
    if m.contentVoting
        vote = []
        feedItem = GetFeedItemFromContent(m.top.content, m.top.itemFocused)
        if VoteHasBeenCast(feedItem.id, vote) = true
            AddButtonToGroup(LCase(vote[0]) + "dButton")
        else
            AddButtonToGroup("likedislikeButton")
        end if
    end if
    m.detailsButtons.focusButton = 0
    m.detailsButtons.iconUri = ""
end function

sub SetDetailsContent(content as Object)
    ' Get the Bookmarks object.
    if content.mediaType = "series"
        m.contentBookmark = SmartBookmark()
    else
        m.contentBookmark = Bookmark()
    end if
    ' Set the content for the progress indicator.
    m.progress.itemContent = content
    ' Title.
    m.titleLabel.text = m.theme.FormatText(m.titleLabel, content.title)
    ' Content description.
    m.description.text = m.theme.FormatText(m.description, content.description)
    ' Add genres, release date, etc.
    m.extrasLabel.text = m.theme.FormatText(m.extrasLabel, Left(content.releaseDate, 4))
    m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, chr(62504), 1)
    if content.genres <> invalid
        for each genre in content.genres
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, genre)
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, chr(62504), 1)
        end for
    end if
    if content.mediaType <> "series"
        if content.ratingObj <> invalid
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, content.ratingObj["rating"])
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, chr(62504), 1)
        end if
    end if
    ' If the media type is NOT a "series", show the duration.  Otherwise, show the number of Seasons/Episodes.
    if content.mediaType <> "series"
        if content.length <> invalid and content.length <> 0
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, GetTime(content.length))
        end if
    else
        if content.hasSeasons = true
            m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, content.numSeasons.toStr() + " Seasons ")
        end if
        m.extrasLabel.text += m.theme.FormatText(m.extrasLabel, content.numEpisodes.toStr() + " Episodes")
    end if
    if content.mediaType = "series"
        m.detailsButtons.minWidth = "150.0"
        ' buttons for series DetailsScreen.
        SetDetailButtons([
            "playallButton"
            "episodesButton"
        ])
    else
        position = [
            0.0
        ]
        remainingStr = []
        ' buttons for content DetailsScreen.
        if ContentCanBeContinued(m.top.content, position, remainingStr) = true
            m.detailsButtons.minWidth = "150.0"
            SetDetailButtons([
                "continueButton"
                "restartButton"
            ])
        else
            m.detailsButtons.minWidth = "150.0"
            SetDetailButtons([
                "playButton"
            ])
        end if
    end if
    ' Display a content thumbnail if requested.
    if m.global.SHOW_DETAILS_THUMBNAIL
        m.poster.uri = content.HDPOSTERurl
    end if
    ' Display the content thumbnail as the background if requested.
    if m.global.USE_THUMBNAIL_BACKGROUND
        SetBackgroundImage(content)
    end if
    ' If this content has been previously 'watched', show an indicator.
    if m.watchedBm.HasBeenWatched(content.id) = true
        m.progress.callfunc("SetWatchedIndicator", invalid)
    end if
end sub

sub OnJumpToItem() ' invoked when jumpToItem field is populated
    content = m.top.content
    ' check if jumpToItem field has valid value
    ' it should be set within interval from 0 to content.Getchildcount()
    if content <> invalid and m.top.jumpToItem >= 0 and content.GetChildCount() > m.top.jumpToItem
        m.top.itemFocused = m.top.jumpToItem
    else if content <> invalid and content.mediaType = "episode" and m.top.jumpToItem >= 0
        m.top.itemFocused = m.top.jumpToItem
    end if
end sub

sub OnItemFocusedChanged(event as Object)
    ' Get the position in the Grid of the selected item.
    focusedItem = event.GetData()
    content = m.top.content.GetChild(focusedItem) ' get metadata of focused item
    SetDetailsContent(content) ' populate DetailsScreen with item metadata
end sub

' The OnKeyEvent() function receives remote control key events
function OnkeyEvent(key as String, press as Boolean) as Boolean
    result = false
    if press
        ' Get the number of buttons in the button group.
        numberOfButtonsInGroup = m.detailsButtons.GetChildCount()
        ' handle "back" button keypress.
        if key = "back"
            SetBackgroundImage(invalid)
            ' handle "left" button keypress
        else if key = "left"
            ' Get the number of the details buttons.
            ' There must be more than one button in the group to process a left key press.
            if numberOfButtonsInGroup > 1
                ' If the index is greater than the number of buttons, process the left key press.
                if m.buttonIndex > 0
                    m.detailsButtons.focusButton = m.buttonIndex - 1
                    result = true
                end if
            end if
            ' handle "right" button keypress
        else if key = "right"
            ' Get the number of the details buttons.
            ' There must be more than one button in the group to process a right key press.
            if numberOfButtonsInGroup > 1
                ' If the index is less than the number of buttons, process the right key press.
                if m.buttonIndex < numberOfButtonsInGroup - 1
                    m.detailsButtons.focusButton = m.buttonIndex + 1
                    result = true
                end if
            end if
        else if key = "options"
            ' Get the Content object.
            content = m.top.content.GetChild(m.top.itemFocused)
            message = []
            ' Check for a long description first.  Otherwise, use the short description.
            if content.longDescription <> invalid
                message.Push(content.longDescription)
            else if content.shortDescription <> invalid
                message.Push(content.shortDescription)
            end if
            if content.Actors <> invalid and content.Actors.Count() > 0
                for each actor in content.Actors
                    message.Push("Actor: " + actor)
                end for
            end if
            if content.Hosts <> invalid and content.Hosts.Count() > 0
                for each host in content.Hosts
                    message.Push("Host: " + host)
                end for
            end if
            if content.Narrators <> invalid and content.Narrators.Count() > 0
                for each narrator in content.Narrators
                    message.Push("Narrator: " + narrator)
                end for
            end if
            if content.Directors <> invalid and content.Directors.Count() > 0
                for each director in content.Directors
                    message.Push("Director: " + director)
                end for
            end if
            if content.Producers <> invalid and content.Producers.Count() > 0
                for each producer in content.Producers
                    message.Push("Producer: " + producer)
                end for
            end if
            m.descriptionDialog = CreateMessageDialog(content.title, message, [
                "Ok"
            ])
            m.descriptionDialog.palette = CreateADialogPalette()
            ' observe the dialog's buttonSelected field to handle button selections
            m.descriptionDialog.observeFieldScoped("buttonSelected", "OkButtonSelected")
            ' display the dialog
            scene = m.top.getScene()
            scene.dialog = m.descriptionDialog
            result = true
        end if
    end if
    return result
end function

'''''''''
' OkButtonSelected: Handles Ok button click on the Description Dialog.
' 
'''''''''
sub OkButtonSelected()
    if m.descriptionDialog.buttonSelected = 0
        ' handle ok button here
        m.descriptionDialog.close = true
    end if
end sub

'''''''''
' SetBackgroundImage: Sets the background image for the Details screen.
' 
' @param {object} I: _content - the content item that contains the image.
' @return {dynamic}
'''''''''
function SetBackgroundImage(_content as object) as void
    if _content = invalid
        m.mainScene.backgrounduri = ""
    else
        m.mainScene.backgrounduri = _content.hdposterurl
    end if
end function

'''''''''
' ContentCanBeContinued: Determines if the vide content can be continued.
' 
' @param {object} I: _content - the video content node.
' @param {object} O: _position - the content playback position.
' @param {object} O: _remaining - time remaining string if the content can be continued.
' @return {boolean} - returns true if content can be continued.  Else, false.
'''''''''
function ContentCanBeContinued(_content as object, _position as object, _remaining as object) as boolean
    feedContent = GetFeedItemFromContent(_content, m.top.itemFocused)
    contentLength = feedContent.length
    ' If the content is for a Series, disregard.
    if feedContent.mediaType = "series"
        return false
    end if
    contentBookmark = Bookmark()
    _position[0] = contentBookmark.GetLastVideoPosition(feedContent.id)
    _remaining[0] = GetTimeRemaining(feedContent.length, _position)
    ' Get the percent of the video that has been viewed.
    percentOfVideoViewed = contentBookmark.GetVideoPlaybackPercentage(feedContent.id, contentLength, _position[0])
    if percentOfVideoViewed > 99.0
        return false
    else
        return contentBookmark.VideoCanBeResumed(feedContent.id, _position)
    end if
end function'//# sourceMappingURL=./DetailsScreen.bs.map