' (c) Copyright 2025, Michael Harnad, all rights reserved.
'import "pkg:/source/utils.bs"
'import "pkg:/source/Theme.bs"

sub Init()
    ' Save a reference to the Theme object.
    m.theme = Theme(m.top.SubType())
    ' Get some field references.
    m.audioPoster = m.top.findNode("audioPoster")
    m.audioPlayer = m.top.findNode("audioPlayer")
    ' Set the state label attributes.
    m.stateLabel = m.top.findNode("stateLabel")
    m.theme.SetFont(m.stateLabel)
    m.stateLabel.visible = false
    ' Get the Roku device size.
    rokuDisplaySize = GetRokuDisplaySize()
    ' Set the poster size.
    m.audioPoster.width = rokuDisplaySize["w"]
    m.audioPoster.height = rokuDisplaySize["h"] - 100
end sub

'''''''''
' onDescriptionChanged: Event handler - handles the description field value changed.
' 
' @param {object} I: _desc - the description string.
'''''''''
sub onDescriptionChanged(_desc as object)
    description = _desc.GetData()
    m.stateLabel.text = m.theme.FormatText(m.stateLabel, description)
    m.stateLabel.visible = true
end sub

'''''''''
' onKeyEvent: Event handler - handles key press events.
' 
' @param {string} I: _key - the key that was pressed.
' @param {boolean} I: _press - true if a key was pressed, else, false if it was released.
' @return {boolean} - returns true if the event was handled, else, false.
'''''''''
function onKeyEvent(_key as string, _press as boolean) as boolean
    result = false
    if _press
        if _key = "play"
            if m.audioPlayer.state = "playing"
                m.audioPlayer.control = "pause"
                stateLabelText = m.theme.GetObjectText("stateLabel", "stateLabel")
                m.stateLabel.text = m.theme.FormatText(m.stateLabel, stateLabelText)
            else if m.audioPlayer.state = "paused"
                m.audioPlayer.control = "resume"
                m.stateLabel.text = m.theme.FormatText(m.stateLabel, m.top.description)
            end if
        end if
    end if
    return result
end function'//# sourceMappingURL=./AudioScreen.bs.map